/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.bits;

import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.representations.BitVector;

public final class UniformCrossover
implements CrossoverOperator<BitVector> {
    private final double p;

    public UniformCrossover() {
        this.p = 0.5;
    }

    public UniformCrossover(double p) {
        this.p = p <= 0.0 ? 0.0 : (p >= 1.0 ? 1.0 : p);
    }

    @Override
    public void cross(BitVector c1, BitVector c2) {
        BitVector.exchangeBits(c1, c2, new BitVector(c1.length(), this.p));
    }

    @Override
    public UniformCrossover split() {
        return this;
    }
}

