/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.bits;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.operators.UndoableMutationOperator;
import org.cicirello.search.operators.bits.BitFlipIterator;
import org.cicirello.search.representations.BitVector;

public final class DefiniteBitFlipMutation
implements UndoableMutationOperator<BitVector>,
IterableMutationOperator<BitVector> {
    private final int b;
    private int[] flipped;

    public DefiniteBitFlipMutation(int b) {
        if (b < 1) {
            throw new IllegalArgumentException("b must be at least 1");
        }
        this.b = b;
    }

    private DefiniteBitFlipMutation(DefiniteBitFlipMutation other) {
        this.b = other.b;
    }

    @Override
    public void mutate(BitVector c) {
        this.flipped = RandomIndexer.sample((int)c.length(), (int)(RandomIndexer.nextBiasedInt((int)DefiniteBitFlipMutation.min(this.b, c.length())) + 1), (int[])null);
        for (int i = 0; i < this.flipped.length; ++i) {
            c.flip(this.flipped[i]);
        }
    }

    @Override
    public void undo(BitVector c) {
        if (this.flipped != null) {
            for (int i = 0; i < this.flipped.length; ++i) {
                c.flip(this.flipped[i]);
            }
        }
    }

    @Override
    public DefiniteBitFlipMutation split() {
        return new DefiniteBitFlipMutation(this);
    }

    @Override
    public MutationIterator iterator(BitVector c) {
        return new BitFlipIterator(c, DefiniteBitFlipMutation.min(this.b, c.length()));
    }

    private static int min(int x, int y) {
        return x < y ? x : y;
    }
}

