/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators.bits;

import org.cicirello.search.operators.MutationIterator;
import org.cicirello.search.representations.BitVector;

final class BitFlipIterator
implements MutationIterator {
    private final BitVector v;
    private final int maxBits;
    private boolean rolled;
    private boolean hasMore;
    private final int[] indexes;
    private int numBits;
    private int[] save;
    private int numBitsSaved;

    BitFlipIterator(BitVector v, int maxBits) {
        this.v = v;
        this.maxBits = maxBits;
        boolean bl = this.hasMore = v.length() >= 1;
        if (this.hasMore) {
            this.indexes = new int[maxBits];
            this.indexes[0] = -1;
            this.numBits = 1;
        } else {
            this.indexes = null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasMore && !this.rolled;
    }

    @Override
    public void nextMutant() {
        if (!this.hasMore) {
            throw new IllegalStateException("no neighbors left");
        }
        if (this.rolled) {
            throw new IllegalStateException("illegal to call nextMutant after calling rollback");
        }
        int j = this.numBits - 1;
        if (this.indexes[0] >= 0) {
            this.v.flip(this.indexes[j]);
        }
        int n = j;
        this.indexes[n] = this.indexes[n] + 1;
        while (j > 0 && this.indexes[j] > this.v.length() - (this.numBits - j)) {
            this.v.flip(this.indexes[--j]);
            int n2 = j;
            this.indexes[n2] = this.indexes[n2] + 1;
        }
        if (this.indexes[0] > this.v.length() - this.numBits) {
            ++this.numBits;
            j = 0;
            this.indexes[0] = 0;
        }
        this.v.flip(this.indexes[j]);
        for (int i = j + 1; i < this.numBits; ++i) {
            this.indexes[i] = this.indexes[i - 1] + 1;
            this.v.flip(this.indexes[i]);
        }
        if (this.numBits == this.maxBits && this.indexes[0] == this.v.length() - this.numBits) {
            this.hasMore = false;
        }
    }

    @Override
    public void setSavepoint() {
        if (this.indexes[0] >= 0) {
            this.save = (int[])this.indexes.clone();
            this.numBitsSaved = this.numBits;
        }
    }

    @Override
    public void rollback() {
        if (!this.rolled) {
            int i;
            this.rolled = true;
            for (i = 0; i < this.numBits; ++i) {
                this.v.flip(this.indexes[i]);
            }
            if (this.save != null) {
                for (i = 0; i < this.numBitsSaved; ++i) {
                    this.v.flip(this.save[i]);
                }
            }
        }
    }
}

