/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.UndoableMutationOperator;

public final class WeightedHybridUndoableMutation<T>
implements UndoableMutationOperator<T> {
    private final ArrayList<UndoableMutationOperator<T>> mutationOps;
    private int last;
    private final int[] choice;

    public WeightedHybridUndoableMutation(Collection<? extends UndoableMutationOperator<T>> mutationOps, int[] weights) {
        if (mutationOps.size() == 0) {
            throw new IllegalArgumentException("Must pass at least 1 UndoableMutationOperator.");
        }
        if (mutationOps.size() != weights.length) {
            throw new IllegalArgumentException("Number of weights must be same as number of mutation operators.");
        }
        this.choice = (int[])weights.clone();
        if (this.choice[0] <= 0) {
            throw new IllegalArgumentException("The weights must be positive.");
        }
        for (int i = 1; i < this.choice.length; ++i) {
            if (this.choice[i] <= 0) {
                throw new IllegalArgumentException("The weights must be positive.");
            }
            this.choice[i] = this.choice[i - 1] + this.choice[i];
        }
        this.mutationOps = new ArrayList(mutationOps.size());
        for (UndoableMutationOperator<T> op : mutationOps) {
            this.mutationOps.add(op);
        }
        this.last = -1;
    }

    private WeightedHybridUndoableMutation(WeightedHybridUndoableMutation<T> other) {
        this.mutationOps = new ArrayList(other.mutationOps.size());
        for (UndoableMutationOperator<T> op : other.mutationOps) {
            this.mutationOps.add((UndoableMutationOperator<T>)op.split());
        }
        this.last = -1;
        this.choice = (int[])other.choice.clone();
    }

    @Override
    public void mutate(T c) {
        int value = RandomIndexer.nextInt((int)this.choice[this.choice.length - 1]);
        this.last = Arrays.binarySearch(this.choice, value);
        this.last = this.last < 0 ? -(this.last + 1) : ++this.last;
        this.mutationOps.get(this.last).mutate(c);
    }

    @Override
    public void undo(T c) {
        if (this.last >= 0) {
            this.mutationOps.get(this.last).undo(c);
        }
    }

    @Override
    public WeightedHybridUndoableMutation<T> split() {
        return new WeightedHybridUndoableMutation<T>(this);
    }
}

