/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.MutationOperator;

public final class WeightedHybridMutation<T>
implements MutationOperator<T> {
    private final ArrayList<MutationOperator<T>> mutationOps;
    private final int[] choice;

    public WeightedHybridMutation(Collection<? extends MutationOperator<T>> mutationOps, int[] weights) {
        if (mutationOps.size() == 0) {
            throw new IllegalArgumentException("Must pass at least 1 MutationOperator.");
        }
        if (mutationOps.size() != weights.length) {
            throw new IllegalArgumentException("Number of weights must be same as number of mutation operators.");
        }
        this.choice = (int[])weights.clone();
        if (this.choice[0] <= 0) {
            throw new IllegalArgumentException("The weights must be positive.");
        }
        for (int i = 1; i < this.choice.length; ++i) {
            if (this.choice[i] <= 0) {
                throw new IllegalArgumentException("The weights must be positive.");
            }
            this.choice[i] = this.choice[i - 1] + this.choice[i];
        }
        this.mutationOps = new ArrayList(mutationOps.size());
        for (MutationOperator<T> op : mutationOps) {
            this.mutationOps.add(op);
        }
    }

    private WeightedHybridMutation(WeightedHybridMutation<T> other) {
        this.mutationOps = new ArrayList(other.mutationOps.size());
        for (MutationOperator<T> op : other.mutationOps) {
            this.mutationOps.add((MutationOperator)op.split());
        }
        this.choice = (int[])other.choice.clone();
    }

    @Override
    public void mutate(T c) {
        int value = RandomIndexer.nextInt((int)this.choice[this.choice.length - 1]);
        int i = Arrays.binarySearch(this.choice, value);
        i = i < 0 ? -(i + 1) : ++i;
        this.mutationOps.get(i).mutate(c);
    }

    @Override
    public WeightedHybridMutation<T> split() {
        return new WeightedHybridMutation<T>(this);
    }
}

