/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;

public final class WeightedHybridCrossover<T>
implements CrossoverOperator<T> {
    private final ArrayList<CrossoverOperator<T>> ops;
    private final int[] choice;

    public WeightedHybridCrossover(Collection<? extends CrossoverOperator<T>> ops, int[] weights) {
        if (ops.size() == 0) {
            throw new IllegalArgumentException("Must pass at least 1 CrossoverOperator.");
        }
        if (ops.size() != weights.length) {
            throw new IllegalArgumentException("Number of weights must be same as number of crossover operators.");
        }
        this.choice = (int[])weights.clone();
        if (this.choice[0] <= 0) {
            throw new IllegalArgumentException("The weights must be positive.");
        }
        for (int i = 1; i < this.choice.length; ++i) {
            if (this.choice[i] <= 0) {
                throw new IllegalArgumentException("The weights must be positive.");
            }
            this.choice[i] = this.choice[i - 1] + this.choice[i];
        }
        this.ops = new ArrayList(ops.size());
        for (CrossoverOperator<T> op : ops) {
            this.ops.add(op);
        }
    }

    private WeightedHybridCrossover(WeightedHybridCrossover<T> other) {
        this.ops = new ArrayList(other.ops.size());
        for (CrossoverOperator<T> op : other.ops) {
            this.ops.add((CrossoverOperator)op.split());
        }
        this.choice = (int[])other.choice.clone();
    }

    @Override
    public void cross(T c1, T c2) {
        int value = RandomIndexer.nextInt((int)this.choice[this.choice.length - 1]);
        int i = Arrays.binarySearch(this.choice, value);
        i = i < 0 ? -(i + 1) : ++i;
        this.ops.get(i).cross(c1, c2);
    }

    @Override
    public WeightedHybridCrossover<T> split() {
        return new WeightedHybridCrossover<T>(this);
    }
}

