/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.UndoableMutationOperator;

public final class HybridUndoableMutation<T>
implements UndoableMutationOperator<T> {
    private final ArrayList<UndoableMutationOperator<T>> mutationOps;
    private int last;

    public HybridUndoableMutation(Collection<? extends UndoableMutationOperator<T>> mutationOps) {
        if (mutationOps.size() == 0) {
            throw new IllegalArgumentException("Must pass at least 1 UndoableMutationOperator.");
        }
        this.mutationOps = new ArrayList(mutationOps.size());
        for (UndoableMutationOperator<T> op : mutationOps) {
            this.mutationOps.add(op);
        }
        this.last = -1;
    }

    private HybridUndoableMutation(HybridUndoableMutation<T> other) {
        this.mutationOps = new ArrayList(other.mutationOps.size());
        for (UndoableMutationOperator<T> op : other.mutationOps) {
            this.mutationOps.add((UndoableMutationOperator<T>)op.split());
        }
        this.last = -1;
    }

    @Override
    public void mutate(T c) {
        this.last = RandomIndexer.nextBiasedInt((int)this.mutationOps.size());
        this.mutationOps.get(this.last).mutate(c);
    }

    @Override
    public void undo(T c) {
        if (this.last >= 0) {
            this.mutationOps.get(this.last).undo(c);
        }
    }

    @Override
    public HybridUndoableMutation<T> split() {
        return new HybridUndoableMutation<T>(this);
    }
}

