/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.MutationOperator;

public final class HybridMutation<T>
implements MutationOperator<T> {
    private final ArrayList<MutationOperator<T>> mutationOps;

    public HybridMutation(Collection<? extends MutationOperator<T>> mutationOps) {
        if (mutationOps.size() == 0) {
            throw new IllegalArgumentException("Must pass at least 1 MutationOperator.");
        }
        this.mutationOps = new ArrayList(mutationOps.size());
        for (MutationOperator<T> op : mutationOps) {
            this.mutationOps.add(op);
        }
    }

    private HybridMutation(HybridMutation<T> other) {
        this.mutationOps = new ArrayList(other.mutationOps.size());
        for (MutationOperator<T> op : other.mutationOps) {
            this.mutationOps.add((MutationOperator)op.split());
        }
    }

    @Override
    public void mutate(T c) {
        this.mutationOps.get(RandomIndexer.nextBiasedInt((int)this.mutationOps.size())).mutate(c);
    }

    @Override
    public HybridMutation<T> split() {
        return new HybridMutation<T>(this);
    }
}

