/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.operators;

import java.util.ArrayList;
import java.util.Collection;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.operators.CrossoverOperator;

public final class HybridCrossover<T>
implements CrossoverOperator<T> {
    private final ArrayList<CrossoverOperator<T>> crossoverOps;

    public HybridCrossover(Collection<? extends CrossoverOperator<T>> crossoverOps) {
        if (crossoverOps.size() == 0) {
            throw new IllegalArgumentException("Must pass at least 1 CrossoverOperator.");
        }
        this.crossoverOps = new ArrayList(crossoverOps.size());
        for (CrossoverOperator<T> op : crossoverOps) {
            this.crossoverOps.add(op);
        }
    }

    private HybridCrossover(HybridCrossover<T> other) {
        this.crossoverOps = new ArrayList(other.crossoverOps.size());
        for (CrossoverOperator<T> op : other.crossoverOps) {
            this.crossoverOps.add((CrossoverOperator)op.split());
        }
    }

    @Override
    public void cross(T c1, T c2) {
        this.crossoverOps.get(RandomIndexer.nextBiasedInt((int)this.crossoverOps.size())).cross(c1, c2);
    }

    @Override
    public HybridCrossover<T> split() {
        return new HybridCrossover<T>(this);
    }
}

