/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.hc;

import org.cicirello.search.Metaheuristic;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SimpleLocalMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.IterableMutationOperator;
import org.cicirello.search.problems.IntegerCostOptimizationProblem;
import org.cicirello.search.problems.OptimizationProblem;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

abstract class AbstractHillClimber<T extends Copyable<T>>
implements Metaheuristic<T>,
SimpleLocalMetaheuristic<T> {
    final OptimizationProblem<T> pOpt;
    final IntegerCostOptimizationProblem<T> pOptInt;
    private final Initializer<T> initializer;
    ProgressTracker<T> tracker;
    final IterableMutationOperator<T> mutation;
    private final OneClimb<T> climber;
    long neighborCount;

    AbstractHillClimber(OptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        if (problem == null || mutation == null || initializer == null || tracker == null) {
            throw new NullPointerException();
        }
        this.pOpt = problem;
        this.pOptInt = null;
        this.mutation = mutation;
        this.initializer = initializer;
        this.tracker = tracker;
        this.climber = this.initClimberDouble();
    }

    AbstractHillClimber(IntegerCostOptimizationProblem<T> problem, IterableMutationOperator<T> mutation, Initializer<T> initializer, ProgressTracker<T> tracker) {
        if (problem == null || mutation == null || initializer == null || tracker == null) {
            throw new NullPointerException();
        }
        this.pOptInt = problem;
        this.pOpt = null;
        this.mutation = mutation;
        this.initializer = initializer;
        this.tracker = tracker;
        this.climber = this.initClimberInt();
    }

    AbstractHillClimber(AbstractHillClimber<T> other) {
        this.pOpt = other.pOpt;
        this.pOptInt = other.pOptInt;
        this.tracker = other.tracker;
        this.mutation = other.mutation.split();
        this.initializer = (Initializer)other.initializer.split();
        this.climber = this.pOptInt != null ? this.initClimberInt() : this.initClimberDouble();
    }

    @Override
    public final SolutionCostPair<T> optimize() {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        ++this.neighborCount;
        return this.climber.climbOnce((Copyable)this.initializer.createCandidateSolution());
    }

    @Override
    public final SolutionCostPair<T> optimize(T start) {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        return this.climber.climbOnce(start.copy());
    }

    @Override
    public final SolutionCostPair<T> optimize(int numRestarts) {
        if (this.tracker.didFindBest() || this.tracker.isStopped()) {
            return null;
        }
        SolutionCostPair<Copyable> best = null;
        for (int i = 0; i < numRestarts && !this.tracker.didFindBest() && !this.tracker.isStopped(); ++i) {
            SolutionCostPair<Copyable> current = this.climber.climbOnce((Copyable)this.initializer.createCandidateSolution());
            ++this.neighborCount;
            if (best != null && current.compareTo(best) >= 0) continue;
            best = current;
        }
        return best;
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.tracker;
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            this.tracker = tracker;
        }
    }

    @Override
    public final Problem<T> getProblem() {
        return this.pOptInt != null ? this.pOptInt : this.pOpt;
    }

    @Override
    public final long getTotalRunLength() {
        return this.neighborCount;
    }

    @Override
    public abstract AbstractHillClimber<T> split();

    abstract OneClimb<T> initClimberInt();

    abstract OneClimb<T> initClimberDouble();

    static interface OneClimb<T extends Copyable<T>> {
        public SolutionCostPair<T> climbOnce(T var1);
    }
}

