/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.SelectionOperator;

public final class TournamentSelection
implements SelectionOperator {
    private final int k;

    public TournamentSelection() {
        this.k = 2;
    }

    public TournamentSelection(int k) {
        if (k < 2) {
            throw new IllegalArgumentException("The tournament size must be at least 2.");
        }
        this.k = k;
    }

    @Override
    public void select(PopulationFitnessVector.Integer fitnesses, int[] selected) {
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.tournament(fitnesses);
        }
    }

    @Override
    public void select(PopulationFitnessVector.Double fitnesses, int[] selected) {
        for (int i = 0; i < selected.length; ++i) {
            selected[i] = this.tournament(fitnesses);
        }
    }

    @Override
    public TournamentSelection split() {
        return this;
    }

    private int tournament(PopulationFitnessVector.Integer fitnesses) {
        int choose = RandomIndexer.nextInt((int)fitnesses.size());
        for (int j = 1; j < this.k; ++j) {
            int other = RandomIndexer.nextInt((int)fitnesses.size());
            if (fitnesses.getFitness(other) <= fitnesses.getFitness(choose)) continue;
            choose = other;
        }
        return choose;
    }

    private int tournament(PopulationFitnessVector.Double fitnesses) {
        int choose = RandomIndexer.nextInt((int)fitnesses.size());
        for (int j = 1; j < this.k; ++j) {
            int other = RandomIndexer.nextInt((int)fitnesses.size());
            if (!(fitnesses.getFitness(other) > fitnesses.getFitness(choose))) continue;
            choose = other;
        }
        return choose;
    }
}

