/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import java.util.concurrent.ThreadLocalRandom;
import org.cicirello.math.rand.RandomIndexer;
import org.cicirello.search.evo.AbstractWeightedSelection;

public class StochasticUniversalSampling
extends AbstractWeightedSelection {
    @Override
    public StochasticUniversalSampling split() {
        return this;
    }

    @Override
    final void selectAll(double[] normalizedWeights, int[] selected) {
        double increment = 1.0 / (double)selected.length;
        double pointer = ThreadLocalRandom.current().nextDouble(increment);
        int j = selected[0] = this.selectOne(normalizedWeights, 0, normalizedWeights.length - 1, pointer);
        for (int i = 1; i < selected.length; ++i) {
            pointer += increment;
            while (normalizedWeights[j] <= pointer) {
                ++j;
            }
            selected[i] = j;
        }
        this.randomize(selected);
    }

    private void randomize(int[] selected) {
        for (int i = selected.length - 1; i > 0; --i) {
            int j = RandomIndexer.nextInt((int)(i + 1));
            if (i == j) continue;
            int temp = selected[i];
            selected[i] = selected[j];
            selected[j] = temp;
        }
    }
}

