/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.math.stats.Statistics;
import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.SelectionOperator;

public final class SigmaScaling
implements SelectionOperator {
    private final SelectionOperator selection;
    private final double c;
    public static final double MIN_SCALED_FITNESS = 0.001;

    public SigmaScaling(SelectionOperator selection) {
        this(selection, 2.0);
    }

    public SigmaScaling(SelectionOperator selection, double c) {
        this.selection = selection;
        this.c = c;
    }

    @Override
    public void select(PopulationFitnessVector.Integer fitnesses, int[] selected) {
        this.selection.select(PopulationFitnessVector.Double.of(this.scale(fitnesses.toDoubleArray())), selected);
    }

    @Override
    public void select(PopulationFitnessVector.Double fitnesses, int[] selected) {
        this.selection.select(PopulationFitnessVector.Double.of(this.scale(fitnesses.toDoubleArray())), selected);
    }

    @Override
    public void init(int generations) {
        this.selection.init(generations);
    }

    @Override
    public SigmaScaling split() {
        return new SigmaScaling((SelectionOperator)this.selection.split(), this.c);
    }

    private double[] scale(double[] f) {
        double adjustment = Statistics.mean((double[])f) - this.c * Statistics.stdev((double[])f);
        for (int i = 0; i < f.length; ++i) {
            int n = i;
            f[n] = f[n] - adjustment;
            if (!(f[i] < 0.001)) continue;
            f[i] = 0.001;
        }
        return f;
    }
}

