/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

public interface PopulationFitnessVector {
    public int size();

    public static interface Double
    extends PopulationFitnessVector {
        public double getFitness(int var1);

        public static Double of(double[] f) {
            class DoubleArrayAsFitnessVector
            implements Double {
                private final double[] f;

                public DoubleArrayAsFitnessVector(double[] f) {
                    this.f = f;
                }

                @Override
                public int size() {
                    return this.f.length;
                }

                @Override
                public double getFitness(int i) {
                    return this.f[i];
                }
            }
            return new DoubleArrayAsFitnessVector(f);
        }

        default public double[] toDoubleArray() {
            double[] d = new double[this.size()];
            for (int i = 0; i < d.length; ++i) {
                d[i] = this.getFitness(i);
            }
            return d;
        }
    }

    public static interface Integer
    extends PopulationFitnessVector {
        public int getFitness(int var1);

        public static Integer of(int[] f) {
            class IntegerArrayAsFitnessVector
            implements Integer {
                private final int[] f;

                public IntegerArrayAsFitnessVector(int[] f) {
                    this.f = f;
                }

                @Override
                public int size() {
                    return this.f.length;
                }

                @Override
                public int getFitness(int i) {
                    return this.f[i];
                }
            }
            return new IntegerArrayAsFitnessVector(f);
        }

        default public int[] toIntArray() {
            int[] f = new int[this.size()];
            for (int i = 0; i < f.length; ++i) {
                f[i] = this.getFitness(i);
            }
            return f;
        }

        default public double[] toDoubleArray() {
            double[] f = new double[this.size()];
            for (int i = 0; i < f.length; ++i) {
                f[i] = this.getFitness(i);
            }
            return f;
        }
    }
}

