/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.math.rand.RandomVariates;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.evo.AbstractEvolutionaryAlgorithm;
import org.cicirello.search.evo.BasePopulation;
import org.cicirello.search.evo.FitnessFunction;
import org.cicirello.search.evo.Population;
import org.cicirello.search.evo.SelectionOperator;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

public class GenerationalMutationOnlyEvolutionaryAlgorithm<T extends Copyable<T>>
extends AbstractEvolutionaryAlgorithm<T> {
    private final MutationOperator<T> mutation;
    private final double M;

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, int eliteCount, ProgressTracker<T> tracker) {
        this(new BasePopulation.Double<T>(n, initializer, f, selection, tracker, eliteCount), f.getProblem(), mutation, mutationRate);
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, int eliteCount, ProgressTracker<T> tracker) {
        this(new BasePopulation.Integer<T>(n, initializer, f, selection, tracker, eliteCount), f.getProblem(), mutation, mutationRate);
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, ProgressTracker<T> tracker) {
        this(n, mutation, mutationRate, initializer, f, selection, 0, tracker);
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, ProgressTracker<T> tracker) {
        this(n, mutation, mutationRate, initializer, f, selection, 0, tracker);
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, int eliteCount) {
        this(n, mutation, mutationRate, initializer, f, selection, eliteCount, new ProgressTracker());
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, int eliteCount) {
        this(n, mutation, mutationRate, initializer, f, selection, eliteCount, new ProgressTracker());
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection) {
        this(n, mutation, mutationRate, initializer, f, selection, new ProgressTracker());
    }

    public GenerationalMutationOnlyEvolutionaryAlgorithm(int n, MutationOperator<T> mutation, double mutationRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection) {
        this(n, mutation, mutationRate, initializer, f, selection, new ProgressTracker());
    }

    private GenerationalMutationOnlyEvolutionaryAlgorithm(Population<T> pop, Problem<T> problem, MutationOperator<T> mutation, double mutationRate) {
        super(pop, problem);
        if (mutation == null) {
            throw new NullPointerException("mutation must be non-null");
        }
        if (mutationRate < 0.0) {
            throw new IllegalArgumentException("mutationRate must not be negative");
        }
        this.mutation = mutation;
        this.M = mutationRate < 1.0 ? mutationRate : 1.0;
    }

    GenerationalMutationOnlyEvolutionaryAlgorithm(GenerationalMutationOnlyEvolutionaryAlgorithm<T> other) {
        super(other);
        this.mutation = (MutationOperator)other.mutation.split();
        this.M = other.M;
    }

    @Override
    public GenerationalMutationOnlyEvolutionaryAlgorithm<T> split() {
        return new GenerationalMutationOnlyEvolutionaryAlgorithm<T>(this);
    }

    @Override
    final int oneGeneration(Population<T> pop) {
        pop.select();
        int count = this.M == 1.0 ? pop.mutableSize() : RandomVariates.nextBinomial((int)pop.mutableSize(), (double)this.M);
        for (int j = 0; j < count; ++j) {
            this.mutation.mutate(pop.get(j));
            pop.updateFitness(j);
        }
        pop.replace();
        return count;
    }
}

