/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.math.rand.RandomVariates;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.evo.AbstractEvolutionaryAlgorithm;
import org.cicirello.search.evo.BasePopulation;
import org.cicirello.search.evo.FitnessFunction;
import org.cicirello.search.evo.Population;
import org.cicirello.search.evo.SelectionOperator;
import org.cicirello.search.operators.CrossoverOperator;
import org.cicirello.search.operators.Initializer;
import org.cicirello.search.operators.MutationOperator;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

public class GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators<T extends Copyable<T>>
extends AbstractEvolutionaryAlgorithm<T> {
    private final MutationOperator<T> mutation;
    private final double M_PRIME;
    private final CrossoverOperator<T> crossover;
    private final double C;

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, int eliteCount, ProgressTracker<T> tracker) {
        this(new BasePopulation.Double<T>(n, initializer, f, selection, tracker, eliteCount), f.getProblem(), mutation, mutationRate, crossover, crossoverRate);
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, int eliteCount, ProgressTracker<T> tracker) {
        this(new BasePopulation.Integer<T>(n, initializer, f, selection, tracker, eliteCount), f.getProblem(), mutation, mutationRate, crossover, crossoverRate);
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, ProgressTracker<T> tracker) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, 0, tracker);
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, ProgressTracker<T> tracker) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, 0, tracker);
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, int eliteCount) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, eliteCount, new ProgressTracker());
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, int eliteCount) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, eliteCount, new ProgressTracker());
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, new ProgressTracker());
    }

    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(int n, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection) {
        this(n, mutation, mutationRate, crossover, crossoverRate, initializer, f, selection, new ProgressTracker());
    }

    private GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(Population<T> pop, Problem<T> problem, MutationOperator<T> mutation, double mutationRate, CrossoverOperator<T> crossover, double crossoverRate) {
        super(pop, problem);
        if (mutation == null) {
            throw new NullPointerException("mutation must be non-null");
        }
        if (crossover == null) {
            throw new NullPointerException("crossover must be non-null");
        }
        if (mutationRate < 0.0) {
            throw new IllegalArgumentException("mutationRate must not be negative");
        }
        if (crossoverRate < 0.0) {
            throw new IllegalArgumentException("crossoverRate must not be negative");
        }
        if (mutationRate + crossoverRate > 1.0) {
            throw new IllegalArgumentException("mutually exclusive operators requires mutationRate + crossoverRate <= 1.0");
        }
        this.C = crossoverRate;
        this.M_PRIME = this.C < 1.0 ? mutationRate / (1.0 - this.C) : 0.0;
        this.mutation = mutation;
        this.crossover = crossover;
    }

    GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators(GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators<T> other) {
        super(other);
        this.mutation = (MutationOperator)other.mutation.split();
        this.crossover = (CrossoverOperator)other.crossover.split();
        this.M_PRIME = other.M_PRIME;
        this.C = other.C;
    }

    @Override
    public GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators<T> split() {
        return new GenerationalEvolutionaryAlgorithmMutuallyExclusiveOperators<T>(this);
    }

    @Override
    final int oneGeneration(Population<T> pop) {
        pop.select();
        int count = this.C < 1.0 ? RandomVariates.nextBinomial((int)(pop.mutableSize() / 2), (double)this.C) : pop.mutableSize() / 2;
        for (int first = 0; first < count; ++first) {
            int second = first + count;
            this.crossover.cross(pop.get(first), pop.get(second));
            pop.updateFitness(first);
            pop.updateFitness(second);
        }
        int crossed = count << 1;
        int mutateCount = 0;
        if (this.C < 1.0) {
            mutateCount = crossed < pop.mutableSize() ? (this.M_PRIME < 1.0 ? RandomVariates.nextBinomial((int)(pop.mutableSize() - crossed), (double)this.M_PRIME) : pop.mutableSize() - crossed) : 0;
            for (int j = crossed + mutateCount - 1; j >= crossed; --j) {
                this.mutation.mutate(pop.get(j));
                pop.updateFitness(j);
            }
        }
        pop.replace();
        return crossed + mutateCount;
    }
}

