/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.SelectionOperator;

public final class FitnessShifter
implements SelectionOperator {
    private final SelectionOperator selection;

    public FitnessShifter(SelectionOperator selection) {
        this.selection = selection;
    }

    @Override
    public void select(PopulationFitnessVector.Integer fitnesses, int[] selected) {
        this.selection.select(PopulationFitnessVector.Integer.of(this.shift(fitnesses.toIntArray())), selected);
    }

    @Override
    public void select(PopulationFitnessVector.Double fitnesses, int[] selected) {
        this.selection.select(PopulationFitnessVector.Double.of(this.shift(fitnesses.toDoubleArray())), selected);
    }

    @Override
    public void init(int generations) {
        this.selection.init(generations);
    }

    @Override
    public FitnessShifter split() {
        return new FitnessShifter((SelectionOperator)this.selection.split());
    }

    private int[] shift(int[] f) {
        int i;
        int adjustment = f[0];
        for (i = 1; i < f.length; ++i) {
            if (f[i] >= adjustment) continue;
            adjustment = f[i];
        }
        --adjustment;
        i = 0;
        while (i < f.length) {
            int n = i++;
            f[n] = f[n] - adjustment;
        }
        return f;
    }

    private double[] shift(double[] f) {
        int i;
        double adjustment = f[0];
        for (i = 1; i < f.length; ++i) {
            if (!(f[i] < adjustment)) continue;
            adjustment = f[i];
        }
        adjustment -= 1.0;
        i = 0;
        while (i < f.length) {
            int n = i++;
            f[n] = f[n] - adjustment;
        }
        return f;
    }
}

