/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.cicirello.search.evo.PopulationMember;
import org.cicirello.util.Copyable;

abstract class EliteSet<T extends Copyable<T>> {
    EliteSet() {
    }

    static final class IntegerFitness<T extends Copyable<T>>
    extends EliteSet<T>
    implements Iterable<PopulationMember.IntegerFitness<T>> {
        private final PopulationMember.IntegerFitness<T>[] elite;
        private int size;
        private final HashSet<T> isElite = new HashSet();

        IntegerFitness(int numElite) {
            this.elite = new PopulationMember.IntegerFitness[numElite];
            this.size = 0;
        }

        IntegerFitness(ArrayList<PopulationMember.IntegerFitness<T>> initialPop, int numElite) {
            this(numElite);
            this.offerAll(initialPop);
        }

        void offerAll(ArrayList<PopulationMember.IntegerFitness<T>> pop) {
            for (PopulationMember.IntegerFitness<T> popMember : pop) {
                this.offer(popMember);
            }
        }

        void offer(PopulationMember.IntegerFitness<T> popMember) {
            if (this.size < this.elite.length) {
                if (!this.isElite.contains(popMember.candidate)) {
                    this.elite[this.size] = popMember;
                    this.percolateUp(this.size);
                    ++this.size;
                    this.isElite.add(popMember.candidate);
                }
            } else if (popMember.getFitness() > this.elite[0].getFitness() && !this.isElite.contains(popMember.candidate)) {
                this.isElite.remove(this.elite[0].candidate);
                this.isElite.add(popMember.candidate);
                this.elite[0] = popMember;
                this.percolateDown(0);
            }
        }

        void clear() {
            this.isElite.clear();
            for (int i = 0; i < this.size; ++i) {
                this.elite[i] = null;
            }
            this.size = 0;
        }

        @Override
        public Iterator<PopulationMember.IntegerFitness<T>> iterator() {
            return new EliteIterator();
        }

        private void percolateDown(int index) {
            int child = (index << 1) + 1;
            if (child < this.size) {
                int minIndex;
                int n = minIndex = this.elite[child].getFitness() < this.elite[index].getFitness() ? child : index;
                if (++child < this.size && this.elite[child].getFitness() < this.elite[minIndex].getFitness()) {
                    minIndex = child;
                }
                if (index != minIndex) {
                    PopulationMember.IntegerFitness<T> temp = this.elite[index];
                    this.elite[index] = this.elite[minIndex];
                    this.elite[minIndex] = temp;
                    this.percolateDown(minIndex);
                }
            }
        }

        private void percolateUp(int index) {
            while (index > 0) {
                int parent = index - 1 >> 1;
                if (this.elite[index].getFitness() >= this.elite[parent].getFitness()) break;
                PopulationMember.IntegerFitness<T> temp = this.elite[index];
                this.elite[index] = this.elite[parent];
                this.elite[parent] = temp;
                index = parent;
            }
        }

        private final class EliteIterator
        implements Iterator<PopulationMember.IntegerFitness<T>> {
            private int nextIndex = 0;

            private EliteIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < IntegerFitness.this.size;
            }

            @Override
            public PopulationMember.IntegerFitness<T> next() {
                if (this.hasNext()) {
                    PopulationMember.IntegerFitness result = IntegerFitness.this.elite[this.nextIndex];
                    ++this.nextIndex;
                    return result;
                }
                throw new NoSuchElementException("No more elements in this iterator.");
            }
        }
    }

    static final class DoubleFitness<T extends Copyable<T>>
    extends EliteSet<T>
    implements Iterable<PopulationMember.DoubleFitness<T>> {
        private final PopulationMember.DoubleFitness<T>[] elite;
        private int size;
        private final HashSet<T> isElite = new HashSet();

        DoubleFitness(int numElite) {
            this.elite = new PopulationMember.DoubleFitness[numElite];
            this.size = 0;
        }

        DoubleFitness(ArrayList<PopulationMember.DoubleFitness<T>> initialPop, int numElite) {
            this(numElite);
            this.offerAll(initialPop);
        }

        void offerAll(ArrayList<PopulationMember.DoubleFitness<T>> pop) {
            for (PopulationMember.DoubleFitness<T> popMember : pop) {
                this.offer(popMember);
            }
        }

        void offer(PopulationMember.DoubleFitness<T> popMember) {
            if (this.size < this.elite.length) {
                if (!this.isElite.contains(popMember.candidate)) {
                    this.elite[this.size] = popMember;
                    this.percolateUp(this.size);
                    ++this.size;
                    this.isElite.add(popMember.candidate);
                }
            } else if (popMember.getFitness() > this.elite[0].getFitness() && !this.isElite.contains(popMember.candidate)) {
                this.isElite.remove(this.elite[0].candidate);
                this.isElite.add(popMember.candidate);
                this.elite[0] = popMember;
                this.percolateDown(0);
            }
        }

        void clear() {
            this.isElite.clear();
            for (int i = 0; i < this.size; ++i) {
                this.elite[i] = null;
            }
            this.size = 0;
        }

        @Override
        public Iterator<PopulationMember.DoubleFitness<T>> iterator() {
            return new EliteIterator();
        }

        private void percolateDown(int index) {
            int child = (index << 1) + 1;
            if (child < this.size) {
                int minIndex;
                int n = minIndex = this.elite[child].getFitness() < this.elite[index].getFitness() ? child : index;
                if (++child < this.size && this.elite[child].getFitness() < this.elite[minIndex].getFitness()) {
                    minIndex = child;
                }
                if (index != minIndex) {
                    PopulationMember.DoubleFitness<T> temp = this.elite[index];
                    this.elite[index] = this.elite[minIndex];
                    this.elite[minIndex] = temp;
                    this.percolateDown(minIndex);
                }
            }
        }

        private void percolateUp(int index) {
            while (index > 0) {
                int parent = index - 1 >> 1;
                if (!(this.elite[index].getFitness() < this.elite[parent].getFitness())) break;
                PopulationMember.DoubleFitness<T> temp = this.elite[index];
                this.elite[index] = this.elite[parent];
                this.elite[parent] = temp;
                index = parent;
            }
        }

        private final class EliteIterator
        implements Iterator<PopulationMember.DoubleFitness<T>> {
            private int nextIndex = 0;

            private EliteIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < DoubleFitness.this.size;
            }

            @Override
            public PopulationMember.DoubleFitness<T> next() {
                if (this.hasNext()) {
                    PopulationMember.DoubleFitness result = DoubleFitness.this.elite[this.nextIndex];
                    ++this.nextIndex;
                    return result;
                }
                throw new NoSuchElementException("No more elements in this iterator.");
            }
        }
    }
}

