/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import org.cicirello.search.evo.FitnessBiasFunction;
import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.StochasticUniversalSampling;

public class BiasedStochasticUniversalSampling
extends StochasticUniversalSampling {
    private final FitnessBiasFunction bias;

    public BiasedStochasticUniversalSampling(FitnessBiasFunction bias) {
        this.bias = bias;
    }

    @Override
    public BiasedStochasticUniversalSampling split() {
        return this;
    }

    @Override
    double[] computeWeightRunningSum(PopulationFitnessVector.Integer fitnesses) {
        double[] p = new double[fitnesses.size()];
        p[0] = this.bias.bias(fitnesses.getFitness(0));
        for (int i = 1; i < p.length; ++i) {
            p[i] = p[i - 1] + this.bias.bias(fitnesses.getFitness(i));
        }
        return p;
    }

    @Override
    double[] computeWeightRunningSum(PopulationFitnessVector.Double fitnesses) {
        double[] p = new double[fitnesses.size()];
        p[0] = this.bias.bias(fitnesses.getFitness(0));
        for (int i = 1; i < p.length; ++i) {
            p[i] = p[i - 1] + this.bias.bias(fitnesses.getFitness(i));
        }
        return p;
    }
}

