/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import java.util.ArrayList;
import java.util.Arrays;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.evo.EliteSet;
import org.cicirello.search.evo.FitnessFunction;
import org.cicirello.search.evo.Population;
import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.PopulationMember;
import org.cicirello.search.evo.SelectionOperator;
import org.cicirello.search.operators.Initializer;
import org.cicirello.util.Copyable;

abstract class BasePopulation<T extends Copyable<T>>
implements Population<T> {
    private ProgressTracker<T> tracker;
    private SolutionCostPair<T> mostFit;

    BasePopulation(ProgressTracker<T> tracker) {
        this.tracker = tracker;
        this.mostFit = null;
    }

    BasePopulation(BasePopulation<T> other) {
        this.tracker = other.tracker;
        this.mostFit = null;
    }

    @Override
    public void init() {
        this.mostFit = null;
    }

    @Override
    public final SolutionCostPair<T> getMostFit() {
        return this.mostFit;
    }

    @Override
    public boolean evolutionIsPaused() {
        return this.tracker.didFindBest() || this.tracker.isStopped();
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.tracker;
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        this.tracker = tracker;
    }

    final void setMostFit(SolutionCostPair<T> mostFit) {
        this.mostFit = mostFit;
        this.tracker.update(mostFit);
    }

    @Override
    public abstract BasePopulation<T> split();

    static final class Integer<T extends Copyable<T>>
    extends BasePopulation<T>
    implements PopulationFitnessVector.Integer {
        private final Initializer<T> initializer;
        private final SelectionOperator selection;
        private final ArrayList<PopulationMember.IntegerFitness<T>> pop;
        private final ArrayList<PopulationMember.IntegerFitness<T>> nextPop;
        private final EliteSet.IntegerFitness<T> elite;
        private final boolean[] updated;
        private final FitnessFunction.Integer<T> f;
        private final int MU;
        private final int LAMBDA;
        private final int[] selected;
        private int bestFitness;

        public Integer(int n, Initializer<T> initializer, FitnessFunction.Integer<T> f, SelectionOperator selection, ProgressTracker<T> tracker, int numElite) {
            super(tracker);
            if (n < 1) {
                throw new IllegalArgumentException("population size n must be positive");
            }
            if (numElite >= n) {
                throw new IllegalArgumentException("number of elite population members must be less than population size");
            }
            if (initializer == null || f == null || selection == null || tracker == null) {
                throw new NullPointerException("passed a null object for a required parameter");
            }
            this.initializer = initializer;
            this.selection = selection;
            this.elite = numElite > 0 ? new EliteSet.IntegerFitness(numElite) : null;
            this.f = f;
            if (numElite > 0) {
                this.MU = n;
                this.LAMBDA = n - numElite;
            } else {
                this.MU = this.LAMBDA = n;
            }
            this.pop = new ArrayList(this.MU);
            this.nextPop = new ArrayList(this.LAMBDA);
            this.selected = new int[this.LAMBDA];
            this.updated = new boolean[this.LAMBDA];
            this.bestFitness = java.lang.Integer.MIN_VALUE;
        }

        private Integer(Integer<T> other) {
            super(other);
            this.f = other.f;
            this.MU = other.MU;
            this.LAMBDA = other.LAMBDA;
            this.initializer = (Initializer)other.initializer.split();
            this.selection = (SelectionOperator)other.selection.split();
            this.pop = new ArrayList(this.MU);
            this.nextPop = new ArrayList(this.LAMBDA);
            this.elite = other.elite != null ? new EliteSet.IntegerFitness(this.MU - this.LAMBDA) : null;
            this.selected = new int[this.LAMBDA];
            this.updated = new boolean[this.LAMBDA];
            this.bestFitness = java.lang.Integer.MIN_VALUE;
        }

        @Override
        public Integer<T> split() {
            return new Integer<T>(this);
        }

        @Override
        public T get(int i) {
            return this.nextPop.get(i).getCandidate();
        }

        @Override
        public int getFitness(int i) {
            return this.pop.get(i).getFitness();
        }

        @Override
        public int size() {
            return this.pop.size();
        }

        @Override
        public int mutableSize() {
            return this.LAMBDA;
        }

        public int getFitnessOfMostFit() {
            return this.bestFitness;
        }

        @Override
        public void updateFitness(int i) {
            int fit = this.f.fitness(this.nextPop.get(i).getCandidate());
            this.nextPop.get(i).setFitness(fit);
            this.updated[i] = true;
            if (fit > this.bestFitness) {
                this.bestFitness = fit;
                this.setMostFit(this.f.getProblem().getSolutionCostPair(this.nextPop.get(i).getCandidate().copy()));
            }
        }

        @Override
        public void select() {
            this.selection.select(this, this.selected);
            for (int j : this.selected) {
                this.nextPop.add((PopulationMember.IntegerFitness<T>)this.pop.get(j).copy());
            }
        }

        @Override
        public void replace() {
            this.pop.clear();
            for (PopulationMember.IntegerFitness<T> e : this.nextPop) {
                this.pop.add(e);
            }
            if (this.elite != null) {
                for (PopulationMember.IntegerFitness<T> e : this.elite) {
                    this.pop.add(e);
                }
                for (int i = 0; i < this.LAMBDA; ++i) {
                    if (!this.updated[i]) continue;
                    this.elite.offer(this.nextPop.get(i));
                    this.updated[i] = false;
                }
            }
            this.nextPop.clear();
        }

        @Override
        public void initOperators(int generations) {
            this.selection.init(generations);
        }

        @Override
        public void init() {
            super.init();
            this.bestFitness = java.lang.Integer.MIN_VALUE;
            this.pop.clear();
            this.nextPop.clear();
            Copyable newBest = null;
            for (int i = 0; i < this.MU; ++i) {
                Copyable c = (Copyable)this.initializer.createCandidateSolution();
                int fit = this.f.fitness(c);
                this.pop.add(new PopulationMember.IntegerFitness<Copyable>(c, fit));
                if (fit <= this.bestFitness) continue;
                this.bestFitness = fit;
                newBest = c;
            }
            this.setMostFit(this.f.getProblem().getSolutionCostPair(newBest.copy()));
            if (this.elite != null) {
                this.elite.clear();
                this.elite.offerAll(this.pop);
                Arrays.fill(this.updated, false);
            }
        }
    }

    static final class Double<T extends Copyable<T>>
    extends BasePopulation<T>
    implements PopulationFitnessVector.Double {
        private final Initializer<T> initializer;
        private final SelectionOperator selection;
        private final ArrayList<PopulationMember.DoubleFitness<T>> pop;
        private final ArrayList<PopulationMember.DoubleFitness<T>> nextPop;
        private final EliteSet.DoubleFitness<T> elite;
        private final boolean[] updated;
        private final FitnessFunction.Double<T> f;
        private final int MU;
        private final int LAMBDA;
        private final int[] selected;
        private double bestFitness;

        public Double(int n, Initializer<T> initializer, FitnessFunction.Double<T> f, SelectionOperator selection, ProgressTracker<T> tracker, int numElite) {
            super(tracker);
            if (n < 1) {
                throw new IllegalArgumentException("population size n must be positive");
            }
            if (numElite >= n) {
                throw new IllegalArgumentException("number of elite population members must be less than population size");
            }
            if (initializer == null || f == null || selection == null || tracker == null) {
                throw new NullPointerException("passed a null object for a required parameter");
            }
            this.initializer = initializer;
            this.selection = selection;
            this.elite = numElite > 0 ? new EliteSet.DoubleFitness(numElite) : null;
            this.f = f;
            if (numElite > 0) {
                this.MU = n;
                this.LAMBDA = n - numElite;
            } else {
                this.MU = this.LAMBDA = n;
            }
            this.pop = new ArrayList(this.MU);
            this.nextPop = new ArrayList(this.LAMBDA);
            this.selected = new int[this.LAMBDA];
            this.updated = new boolean[this.LAMBDA];
            this.bestFitness = java.lang.Double.NEGATIVE_INFINITY;
        }

        private Double(Double<T> other) {
            super(other);
            this.f = other.f;
            this.MU = other.MU;
            this.LAMBDA = other.LAMBDA;
            this.initializer = (Initializer)other.initializer.split();
            this.selection = (SelectionOperator)other.selection.split();
            this.pop = new ArrayList(this.MU);
            this.nextPop = new ArrayList(this.LAMBDA);
            this.elite = other.elite != null ? new EliteSet.DoubleFitness(this.MU - this.LAMBDA) : null;
            this.selected = new int[this.LAMBDA];
            this.updated = new boolean[this.LAMBDA];
            this.bestFitness = java.lang.Double.NEGATIVE_INFINITY;
        }

        @Override
        public Double<T> split() {
            return new Double<T>(this);
        }

        @Override
        public T get(int i) {
            return this.nextPop.get(i).getCandidate();
        }

        @Override
        public double getFitness(int i) {
            return this.pop.get(i).getFitness();
        }

        @Override
        public int size() {
            return this.pop.size();
        }

        @Override
        public int mutableSize() {
            return this.LAMBDA;
        }

        public double getFitnessOfMostFit() {
            return this.bestFitness;
        }

        @Override
        public void updateFitness(int i) {
            double fit = this.f.fitness(this.nextPop.get(i).getCandidate());
            this.nextPop.get(i).setFitness(fit);
            this.updated[i] = true;
            if (fit > this.bestFitness) {
                this.bestFitness = fit;
                this.setMostFit(this.f.getProblem().getSolutionCostPair(this.nextPop.get(i).getCandidate().copy()));
            }
        }

        @Override
        public void select() {
            this.selection.select(this, this.selected);
            for (int j : this.selected) {
                this.nextPop.add((PopulationMember.DoubleFitness<T>)this.pop.get(j).copy());
            }
        }

        @Override
        public void replace() {
            this.pop.clear();
            for (PopulationMember.DoubleFitness<T> e : this.nextPop) {
                this.pop.add(e);
            }
            if (this.elite != null) {
                for (PopulationMember.DoubleFitness<T> e : this.elite) {
                    this.pop.add(e);
                }
                for (int i = 0; i < this.LAMBDA; ++i) {
                    if (!this.updated[i]) continue;
                    this.elite.offer(this.nextPop.get(i));
                    this.updated[i] = false;
                }
            }
            this.nextPop.clear();
        }

        @Override
        public void initOperators(int generations) {
            this.selection.init(generations);
        }

        @Override
        public void init() {
            super.init();
            this.bestFitness = java.lang.Double.NEGATIVE_INFINITY;
            this.pop.clear();
            this.nextPop.clear();
            Copyable newBest = null;
            for (int i = 0; i < this.MU; ++i) {
                Copyable c = (Copyable)this.initializer.createCandidateSolution();
                double fit = this.f.fitness(c);
                this.pop.add(new PopulationMember.DoubleFitness<Copyable>(c, fit));
                if (!(fit > this.bestFitness)) continue;
                this.bestFitness = fit;
                newBest = c;
            }
            this.setMostFit(this.f.getProblem().getSolutionCostPair(newBest.copy()));
            if (this.elite != null) {
                this.elite.clear();
                this.elite.offerAll(this.pop);
                Arrays.fill(this.updated, false);
            }
        }
    }
}

