/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.evo;

import java.util.function.DoubleUnaryOperator;
import org.cicirello.search.evo.PopulationFitnessVector;
import org.cicirello.search.evo.SelectionOperator;

abstract class AbstractWeightedSelection
implements SelectionOperator {
    @Override
    public final void select(PopulationFitnessVector.Integer fitnesses, int[] selected) {
        this.selectAll(this.normalizeWeights(this.computeWeightRunningSum(fitnesses)), selected);
    }

    @Override
    public final void select(PopulationFitnessVector.Double fitnesses, int[] selected) {
        this.selectAll(this.normalizeWeights(this.computeWeightRunningSum(fitnesses)), selected);
    }

    double[] computeWeightRunningSum(PopulationFitnessVector.Integer fitnesses) {
        double[] p = new double[fitnesses.size()];
        p[0] = fitnesses.getFitness(0);
        for (int i = 1; i < p.length; ++i) {
            p[i] = p[i - 1] + (double)fitnesses.getFitness(i);
        }
        return p;
    }

    double[] computeWeightRunningSum(PopulationFitnessVector.Double fitnesses) {
        double[] p = new double[fitnesses.size()];
        p[0] = fitnesses.getFitness(0);
        for (int i = 1; i < p.length; ++i) {
            p[i] = p[i - 1] + fitnesses.getFitness(i);
        }
        return p;
    }

    final double[] computeWeightRunningSumRanks(int[] indexes, DoubleUnaryOperator rankToWeight) {
        int i;
        double[] p = new double[indexes.length];
        for (i = 0; i < indexes.length; ++i) {
            p[indexes[i]] = rankToWeight.applyAsDouble(i);
        }
        for (i = 1; i < p.length; ++i) {
            int n = i;
            p[n] = p[n] + p[i - 1];
        }
        return p;
    }

    final int selectOne(double[] normalizedWeights, int first, int last, double u) {
        if (last <= first) {
            return first;
        }
        int mid = first + last >> 1;
        if (u < normalizedWeights[mid]) {
            return this.selectOne(normalizedWeights, first, mid, u);
        }
        return this.selectOne(normalizedWeights, mid + 1, last, u);
    }

    abstract void selectAll(double[] var1, int[] var2);

    final int[] sortedIndexes(PopulationFitnessVector.Integer fitnesses) {
        int[] indexes = new int[fitnesses.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        this.sort(indexes, fitnesses, 0, indexes.length - 1);
        return indexes;
    }

    final int[] sortedIndexes(PopulationFitnessVector.Double fitnesses) {
        int[] indexes = new int[fitnesses.size()];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        this.sort(indexes, fitnesses, 0, indexes.length - 1);
        return indexes;
    }

    private double[] normalizeWeights(double[] weights) {
        double total = weights[weights.length - 1];
        weights[weights.length - 1] = 1.0;
        int i = weights.length - 2;
        while (i >= 0) {
            int n = i--;
            weights[n] = weights[n] / total;
        }
        return weights;
    }

    private void sort(int[] indexes, PopulationFitnessVector.Double fitnesses, int first, int last) {
        if (first < last) {
            int mid = first + last >> 1;
            this.sort(indexes, fitnesses, first, mid);
            this.sort(indexes, fitnesses, mid + 1, last);
            this.merge(indexes, fitnesses, first, mid, last);
        }
    }

    private void sort(int[] indexes, PopulationFitnessVector.Integer fitnesses, int first, int last) {
        if (first < last) {
            int mid = first + last >> 1;
            this.sort(indexes, fitnesses, first, mid);
            this.sort(indexes, fitnesses, mid + 1, last);
            this.merge(indexes, fitnesses, first, mid, last);
        }
    }

    private void merge(int[] indexes, PopulationFitnessVector.Double fitnesses, int first, int mid, int last) {
        int[] left = new int[mid - first + 1];
        int[] right = new int[last - mid];
        System.arraycopy(indexes, first, left, 0, left.length);
        System.arraycopy(indexes, mid + 1, right, 0, right.length);
        int i = 0;
        int j = 0;
        int k = first;
        while (i < left.length && j < right.length) {
            if (fitnesses.getFitness(left[i]) <= fitnesses.getFitness(right[j])) {
                indexes[k] = left[i];
                ++i;
            } else {
                indexes[k] = right[j];
                ++j;
            }
            ++k;
        }
        while (i < left.length) {
            indexes[k] = left[i];
            ++i;
            ++k;
        }
        while (j < right.length) {
            indexes[k] = right[j];
            ++j;
            ++k;
        }
    }

    private void merge(int[] indexes, PopulationFitnessVector.Integer fitnesses, int first, int mid, int last) {
        int[] left = new int[mid - first + 1];
        int[] right = new int[last - mid];
        System.arraycopy(indexes, first, left, 0, left.length);
        System.arraycopy(indexes, mid + 1, right, 0, right.length);
        int i = 0;
        int j = 0;
        int k = first;
        while (i < left.length && j < right.length) {
            if (fitnesses.getFitness(left[i]) <= fitnesses.getFitness(right[j])) {
                indexes[k] = left[i];
                ++i;
            } else {
                indexes[k] = right[j];
                ++j;
            }
            ++k;
        }
        while (i < left.length) {
            indexes[k] = left[i];
            ++i;
            ++k;
        }
        while (j < right.length) {
            indexes[k] = right[j];
            ++j;
            ++k;
        }
    }
}

