/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.concurrent;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.cicirello.search.ReoptimizableMetaheuristic;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.concurrent.ParallelMultistarterUtil;
import org.cicirello.search.concurrent.TimedParallelMultistarter;
import org.cicirello.search.restarts.ConstantRestartSchedule;
import org.cicirello.search.restarts.Multistarter;
import org.cicirello.search.restarts.ReoptimizableMultistarter;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

public final class TimedParallelReoptimizableMultistarter<T extends Copyable<T>>
extends TimedParallelMultistarter<T>
implements ReoptimizableMetaheuristic<T> {
    private final Function<Multistarter<T>, Callable<SolutionCostPair<T>>> createReoptimizerCallable = multistartSearch -> () -> ((ReoptimizableMultistarter)multistartSearch).reoptimize(Integer.MAX_VALUE);

    public TimedParallelReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, int runLength, int numThreads) {
        this(search, (RestartSchedule)new ConstantRestartSchedule(runLength), numThreads);
    }

    public TimedParallelReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, RestartSchedule r, int numThreads) {
        this(new ReoptimizableMultistarter<T>(search, r), numThreads);
    }

    public TimedParallelReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, Collection<? extends RestartSchedule> schedules) {
        super(ParallelMultistarterUtil.toReoptimizableMultistarters(search, schedules), false);
    }

    public TimedParallelReoptimizableMultistarter(Collection<? extends ReoptimizableMetaheuristic<T>> searches, Collection<? extends RestartSchedule> schedules) {
        super(ParallelMultistarterUtil.toReoptimizableMultistarters(searches, schedules), false);
    }

    public TimedParallelReoptimizableMultistarter(Collection<? extends ReoptimizableMetaheuristic<T>> searches, int runLength) {
        this(searches, (Collection<RestartSchedule>)ConstantRestartSchedule.createRestartSchedules(searches.size(), runLength));
    }

    public TimedParallelReoptimizableMultistarter(ReoptimizableMultistarter<T> multistartSearch2, int numThreads) {
        super(multistartSearch2, numThreads);
    }

    public TimedParallelReoptimizableMultistarter(Collection<ReoptimizableMultistarter<T>> multistarters) {
        super(multistarters, true);
    }

    private TimedParallelReoptimizableMultistarter(TimedParallelReoptimizableMultistarter<T> other) {
        super(other);
    }

    @Override
    public SolutionCostPair<T> reoptimize(int time) {
        return this.threadedOptimize(time, this.createReoptimizerCallable);
    }

    @Override
    public TimedParallelReoptimizableMultistarter<T> split() {
        return new TimedParallelReoptimizableMultistarter<T>(this);
    }
}

