/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.cicirello.search.Metaheuristic;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.problems.Problem;
import org.cicirello.search.restarts.ConstantRestartSchedule;
import org.cicirello.search.restarts.Multistarter;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

public class TimedParallelMultistarter<T extends Copyable<T>>
implements Metaheuristic<T>,
AutoCloseable {
    public static final int TIME_UNIT_MS = 1000;
    private final ArrayList<Multistarter<T>> multistarters;
    private final ExecutorService threadPool;
    private int timeUnit;
    private ArrayList<SolutionCostPair<T>> history;
    private final Function<Multistarter<T>, Callable<SolutionCostPair<T>>> createOptimizerCallable = multistartSearch -> () -> multistartSearch.optimize(Integer.MAX_VALUE);

    public TimedParallelMultistarter(Metaheuristic<T> search, int runLength, int numThreads) {
        this(search, new ConstantRestartSchedule(runLength), numThreads);
    }

    public TimedParallelMultistarter(Metaheuristic<T> search, RestartSchedule r, int numThreads) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("must be at least 1 thread");
        }
        this.multistarters = new ArrayList();
        this.multistarters.add(new Multistarter<T>(search, r));
        for (int i = 1; i < numThreads; ++i) {
            this.multistarters.add(new Multistarter(search.split(), (RestartSchedule)r.split()));
        }
        this.threadPool = Executors.newFixedThreadPool(numThreads);
        this.timeUnit = 1000;
        this.history = null;
    }

    public TimedParallelMultistarter(Metaheuristic<T> search, Collection<? extends RestartSchedule> schedules) {
        if (schedules.size() < 1) {
            throw new IllegalArgumentException("Must pass at least one schedule.");
        }
        this.multistarters = new ArrayList();
        boolean addedFirst = false;
        for (RestartSchedule restartSchedule : schedules) {
            if (addedFirst) {
                this.multistarters.add(new Multistarter(search.split(), restartSchedule));
                continue;
            }
            this.multistarters.add(new Multistarter<T>(search, restartSchedule));
            addedFirst = true;
        }
        this.threadPool = Executors.newFixedThreadPool(this.multistarters.size());
        this.timeUnit = 1000;
        this.history = null;
    }

    public TimedParallelMultistarter(Collection<? extends Metaheuristic<T>> searches, Collection<? extends RestartSchedule> schedules) {
        if (searches.size() != schedules.size()) {
            throw new IllegalArgumentException("number of searches and number of schedules must be the same");
        }
        this.multistarters = new ArrayList();
        Iterator<? extends RestartSchedule> rs = schedules.iterator();
        ProgressTracker t = null;
        Problem problem = null;
        for (Metaheuristic<T> s : searches) {
            if (problem == null) {
                problem = s.getProblem();
            } else if (s.getProblem() != problem) {
                throw new IllegalArgumentException("All Metaheuristics in searches must solve the same problem.");
            }
            if (t == null) {
                t = s.getProgressTracker();
            } else if (s.getProgressTracker() != t) {
                throw new IllegalArgumentException("All Metaheuristics in searches must share a single ProgressTracker.");
            }
            this.multistarters.add(new Multistarter<T>(s, rs.next()));
        }
        this.threadPool = Executors.newFixedThreadPool(this.multistarters.size());
        this.timeUnit = 1000;
        this.history = null;
    }

    public TimedParallelMultistarter(Collection<? extends Metaheuristic<T>> searches, int runLength) {
        this(searches, ConstantRestartSchedule.createRestartSchedules(searches.size(), runLength));
    }

    public TimedParallelMultistarter(Multistarter<T> multistartSearch2, int numThreads) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("must be at least 1 thread");
        }
        this.multistarters = new ArrayList();
        this.multistarters.add(multistartSearch2);
        for (int i = 1; i < numThreads; ++i) {
            this.multistarters.add((Multistarter<T>)multistartSearch2.split());
        }
        this.threadPool = Executors.newFixedThreadPool(numThreads);
        this.timeUnit = 1000;
        this.history = null;
    }

    public TimedParallelMultistarter(Collection<? extends Multistarter<T>> multistarters) {
        this(multistarters, true);
    }

    TimedParallelMultistarter(Collection<? extends Multistarter<T>> multistarters, boolean verifyState) {
        if (verifyState) {
            ProgressTracker<T> t = null;
            Problem<T> problem = null;
            for (Multistarter<T> m : multistarters) {
                if (problem == null) {
                    problem = m.getProblem();
                } else if (m.getProblem() != problem) {
                    throw new IllegalArgumentException("All Multistarters in searches must solve the same problem.");
                }
                if (t == null) {
                    t = m.getProgressTracker();
                    continue;
                }
                if (m.getProgressTracker() == t) continue;
                throw new IllegalArgumentException("All Multistarters must share a single ProgressTracker.");
            }
        }
        this.multistarters = new ArrayList();
        for (Multistarter<T> m : multistarters) {
            this.multistarters.add(m);
        }
        this.threadPool = Executors.newFixedThreadPool(multistarters.size());
        this.timeUnit = 1000;
        this.history = null;
    }

    TimedParallelMultistarter(TimedParallelMultistarter<T> other) {
        this.multistarters = new ArrayList(other.multistarters.size());
        for (Multistarter<T> m : other.multistarters) {
            this.multistarters.add((Multistarter<T>)m.split());
        }
        this.threadPool = Executors.newFixedThreadPool(this.multistarters.size());
        if (other.isClosed()) {
            this.close();
        }
        this.timeUnit = other.timeUnit;
        this.history = null;
    }

    public final void setTimeUnit(int timeUnit) {
        if (timeUnit < 1) {
            throw new IllegalArgumentException("The unit of time must be at least 1 millisecond.");
        }
        this.timeUnit = timeUnit;
    }

    public final int getTimeUnit() {
        return this.timeUnit;
    }

    public final ArrayList<SolutionCostPair<T>> getSearchHistory() {
        return this.history;
    }

    @Override
    public final SolutionCostPair<T> optimize(int time) {
        return this.threadedOptimize(time, this.createOptimizerCallable);
    }

    @Override
    public final void close() {
        this.threadPool.shutdown();
    }

    public final boolean isClosed() {
        return this.threadPool.isShutdown();
    }

    @Override
    public TimedParallelMultistarter<T> split() {
        return new TimedParallelMultistarter<T>(this);
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.multistarters.get(0).getProgressTracker();
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            for (Multistarter<T> m : this.multistarters) {
                m.setProgressTracker(tracker);
            }
        }
    }

    @Override
    public final Problem<T> getProblem() {
        return this.multistarters.get(0).getProblem();
    }

    @Override
    public final long getTotalRunLength() {
        long total = 0L;
        for (Multistarter<T> m : this.multistarters) {
            total += m.getTotalRunLength();
        }
        return total;
    }

    final SolutionCostPair<T> threadedOptimize(int time, Function<Multistarter<T>, Callable<SolutionCostPair<T>>> icf) {
        if (this.threadPool.isShutdown()) {
            throw new IllegalStateException("Previously closed.");
        }
        SolutionCostPair bestRestart = null;
        ProgressTracker<T> tracker = this.multistarters.get(0).getProgressTracker();
        tracker.start();
        this.history = new ArrayList(time);
        if (!tracker.didFindBest()) {
            ArrayList<Future<SolutionCostPair<Multistarter<T>>>> futures = new ArrayList<Future<SolutionCostPair<Multistarter<T>>>>();
            for (Multistarter<T> multistarter : this.multistarters) {
                futures.add(this.threadPool.submit(icf.apply(multistarter)));
            }
            for (int i = 0; i < time && !tracker.didFindBest(); ++i) {
                try {
                    Thread.sleep(this.timeUnit);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                this.history.add(tracker.getSolutionCostPair());
            }
            tracker.stop();
            for (Future future : futures) {
                try {
                    SolutionCostPair pair = (SolutionCostPair)future.get();
                    if (bestRestart != null && (pair == null || pair.compareTo(bestRestart) >= 0)) continue;
                    bestRestart = pair;
                }
                catch (Exception exception) {}
            }
        }
        return bestRestart;
    }
}

