/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.concurrent;

import java.util.Collection;
import org.cicirello.search.ReoptimizableMetaheuristic;
import org.cicirello.search.concurrent.ParallelMultistarterUtil;
import org.cicirello.search.concurrent.ParallelReoptimizableMetaheuristic;
import org.cicirello.search.restarts.ConstantRestartSchedule;
import org.cicirello.search.restarts.ReoptimizableMultistarter;
import org.cicirello.search.restarts.RestartSchedule;
import org.cicirello.util.Copyable;

public final class ParallelReoptimizableMultistarter<T extends Copyable<T>>
extends ParallelReoptimizableMetaheuristic<T> {
    public ParallelReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, int runLength, int numThreads) {
        this(search, new ConstantRestartSchedule(runLength), numThreads);
    }

    public ParallelReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, RestartSchedule r, int numThreads) {
        super(new ReoptimizableMultistarter<T>(search, r), numThreads);
    }

    public ParallelReoptimizableMultistarter(ReoptimizableMetaheuristic<T> search, Collection<? extends RestartSchedule> schedules) {
        super(ParallelMultistarterUtil.toReoptimizableMultistarters(search, schedules), false);
    }

    public ParallelReoptimizableMultistarter(Collection<? extends ReoptimizableMetaheuristic<T>> searches, Collection<? extends RestartSchedule> schedules) {
        super(ParallelMultistarterUtil.toReoptimizableMultistarters(searches, schedules), false);
    }

    public ParallelReoptimizableMultistarter(Collection<? extends ReoptimizableMetaheuristic<T>> searches, int runLength) {
        this(searches, ConstantRestartSchedule.createRestartSchedules(searches.size(), runLength));
    }

    public ParallelReoptimizableMultistarter(ReoptimizableMultistarter<T> multistartSearch, int numThreads) {
        super(multistartSearch, numThreads);
    }

    public ParallelReoptimizableMultistarter(Collection<ReoptimizableMultistarter<T>> multistarters) {
        super(multistarters);
    }

    private ParallelReoptimizableMultistarter(ParallelReoptimizableMultistarter<T> other) {
        super(other);
    }

    @Override
    public ParallelReoptimizableMultistarter<T> split() {
        return new ParallelReoptimizableMultistarter<T>(this);
    }
}

