/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.cicirello.search.Metaheuristic;
import org.cicirello.search.ProgressTracker;
import org.cicirello.search.SolutionCostPair;
import org.cicirello.search.problems.Problem;
import org.cicirello.util.Copyable;

public class ParallelMetaheuristic<T extends Copyable<T>>
implements Metaheuristic<T>,
AutoCloseable {
    private final ArrayList<Metaheuristic<T>> metaheuristics;
    private final ExecutorService threadPool;

    public ParallelMetaheuristic(Metaheuristic<T> search, int numThreads) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("must be at least 1 thread");
        }
        this.metaheuristics = new ArrayList(numThreads);
        this.metaheuristics.add(search);
        for (int i = 1; i < numThreads; ++i) {
            this.metaheuristics.add((Metaheuristic<T>)search.split());
        }
        this.threadPool = Executors.newFixedThreadPool(numThreads);
    }

    public ParallelMetaheuristic(Collection<? extends Metaheuristic<T>> searches) {
        this(searches, true);
    }

    ParallelMetaheuristic(Collection<? extends Metaheuristic<T>> searches, boolean verifyState) {
        if (verifyState) {
            ProgressTracker t = null;
            Problem problem = null;
            for (Metaheuristic<T> m : searches) {
                if (problem == null) {
                    problem = m.getProblem();
                } else if (m.getProblem() != problem) {
                    throw new IllegalArgumentException("All metaheuristics in searches must solve the same problem.");
                }
                if (t == null) {
                    t = m.getProgressTracker();
                    continue;
                }
                if (m.getProgressTracker() == t) continue;
                throw new IllegalArgumentException("All metaheuristics must share a single ProgressTracker.");
            }
        }
        this.metaheuristics = new ArrayList(searches.size());
        for (Metaheuristic<T> m : searches) {
            this.metaheuristics.add(m);
        }
        this.threadPool = Executors.newFixedThreadPool(this.metaheuristics.size());
    }

    ParallelMetaheuristic(ParallelMetaheuristic<T> other) {
        this.metaheuristics = new ArrayList(other.metaheuristics.size());
        for (Metaheuristic<T> m : other.metaheuristics) {
            this.metaheuristics.add((Metaheuristic<T>)m.split());
        }
        this.threadPool = Executors.newFixedThreadPool(this.metaheuristics.size());
        if (other.isClosed()) {
            this.close();
        }
    }

    @Override
    public final SolutionCostPair<T> optimize(int runLength) {
        return this.threadedOptimize(search -> () -> search.optimize(runLength));
    }

    @Override
    public final void close() {
        this.threadPool.shutdown();
    }

    public final boolean isClosed() {
        return this.threadPool.isShutdown();
    }

    @Override
    public ParallelMetaheuristic<T> split() {
        return new ParallelMetaheuristic<T>(this);
    }

    @Override
    public final ProgressTracker<T> getProgressTracker() {
        return this.metaheuristics.get(0).getProgressTracker();
    }

    @Override
    public final void setProgressTracker(ProgressTracker<T> tracker) {
        if (tracker != null) {
            for (Metaheuristic<T> m : this.metaheuristics) {
                m.setProgressTracker(tracker);
            }
        }
    }

    @Override
    public final Problem<T> getProblem() {
        return this.metaheuristics.get(0).getProblem();
    }

    @Override
    public final long getTotalRunLength() {
        long total = 0L;
        for (Metaheuristic<T> m : this.metaheuristics) {
            total += m.getTotalRunLength();
        }
        return total;
    }

    final SolutionCostPair<T> threadedOptimize(Function<Metaheuristic<T>, Callable<SolutionCostPair<T>>> icf) {
        if (this.threadPool.isShutdown()) {
            throw new IllegalStateException("This ParallelMetaheuristic was previously closed.");
        }
        SolutionCostPair bestParallelRun = null;
        ProgressTracker tracker = this.metaheuristics.get(0).getProgressTracker();
        if (!tracker.isStopped() && !tracker.didFindBest()) {
            ArrayList<Future<SolutionCostPair<Metaheuristic<T>>>> futures = new ArrayList<Future<SolutionCostPair<Metaheuristic<T>>>>();
            for (Metaheuristic<T> metaheuristic : this.metaheuristics) {
                futures.add(this.threadPool.submit(icf.apply(metaheuristic)));
            }
            for (Future future : futures) {
                try {
                    SolutionCostPair pair = (SolutionCostPair)future.get();
                    if (bestParallelRun != null && (pair == null || pair.compareTo(bestParallelRun) >= 0)) continue;
                    bestParallelRun = pair;
                }
                catch (InterruptedException ex) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {}
            }
        }
        return bestParallelRun;
    }
}

