/*
 * Decompiled with CFR 0.152.
 */
package org.cicirello.search;

import org.cicirello.util.Copyable;

public final class SolutionCostPair<T extends Copyable<T>>
implements Comparable<SolutionCostPair<T>> {
    private final T solution;
    private final int cost;
    private final double costD;
    private final boolean containsIntCost;
    private final boolean isKnownOptimal;

    public SolutionCostPair(T solution, int cost, boolean isKnownOptimal) {
        this.solution = solution;
        this.cost = cost;
        this.costD = this.cost;
        this.containsIntCost = true;
        this.isKnownOptimal = isKnownOptimal;
    }

    public SolutionCostPair(T solution, double cost, boolean isKnownOptimal) {
        this.solution = solution;
        this.costD = cost;
        this.cost = (int)(cost + 0.5);
        this.containsIntCost = false;
        this.isKnownOptimal = isKnownOptimal;
    }

    public int getCost() {
        return this.cost;
    }

    public double getCostDouble() {
        return this.costD;
    }

    public T getSolution() {
        return this.solution;
    }

    public boolean containsIntCost() {
        return this.containsIntCost;
    }

    public boolean containsKnownOptimal() {
        return this.isKnownOptimal;
    }

    @Override
    public int compareTo(SolutionCostPair<T> other) {
        if (this.containsIntCost) {
            return this.cost - other.cost;
        }
        if (this.costD < other.costD) {
            return -1;
        }
        if (this.costD > other.costD) {
            return 1;
        }
        return 0;
    }
}

