/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.json.jackson.format;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cibseven.spin.DeserializationTypeValidator;
import org.cibseven.spin.SpinRuntimeException;
import org.cibseven.spin.impl.json.jackson.JacksonJsonLogger;
import org.cibseven.spin.impl.json.jackson.format.JacksonJsonDataFormat;
import org.cibseven.spin.spi.DataFormatMapper;

public class JacksonJsonDataFormatMapper
implements DataFormatMapper {
    private static final JacksonJsonLogger LOG = JacksonJsonLogger.JSON_TREE_LOGGER;
    protected JacksonJsonDataFormat format;

    public JacksonJsonDataFormatMapper(JacksonJsonDataFormat format) {
        this.format = format;
    }

    public boolean canMap(Object parameter) {
        return parameter != null;
    }

    public String getCanonicalTypeName(Object object) {
        return this.format.getCanonicalTypeName(object);
    }

    public Object mapJavaToInternal(Object parameter) {
        ObjectMapper mapper = this.format.getObjectMapper();
        try {
            return mapper.valueToTree(parameter);
        }
        catch (IllegalArgumentException e) {
            throw LOG.unableToMapInput(parameter, e);
        }
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> type) {
        return this.mapInternalToJava(parameter, type, null);
    }

    public <T> T mapInternalToJava(Object parameter, Class<T> type, DeserializationTypeValidator validator) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        return (T)this.mapInternalToJava(parameter, javaType, validator);
    }

    public <T> T mapInternalToJava(Object parameter, String typeIdentifier) {
        return this.mapInternalToJava(parameter, typeIdentifier, null);
    }

    public <T> T mapInternalToJava(Object parameter, String typeIdentifier, DeserializationTypeValidator validator) {
        try {
            Class<?> aClass = Class.forName(typeIdentifier, true, Thread.currentThread().getContextClassLoader());
            return (T)this.mapInternalToJava(parameter, aClass, validator);
        }
        catch (ClassNotFoundException e) {
            JavaType javaType = this.format.constructJavaTypeFromCanonicalString(typeIdentifier);
            Object result = this.mapInternalToJava(parameter, javaType, validator);
            return (T)result;
        }
    }

    public <C> C mapInternalToJava(Object parameter, JavaType type) {
        return this.mapInternalToJava(parameter, type, null);
    }

    public <C> C mapInternalToJava(Object parameter, JavaType type, DeserializationTypeValidator validator) {
        JsonNode jsonNode = (JsonNode)parameter;
        try {
            this.validateType(type, validator);
            ObjectMapper mapper = this.format.getObjectMapper();
            return (C)mapper.readValue(mapper.treeAsTokens((TreeNode)jsonNode), type);
        }
        catch (IOException | SpinRuntimeException e) {
            throw LOG.unableToDeserialize(jsonNode, type, (Exception)e);
        }
    }

    protected void validateType(JavaType type, DeserializationTypeValidator validator) {
        if (validator != null) {
            ArrayList<String> invalidTypes = new ArrayList<String>();
            this.validateType(type, validator, invalidTypes);
            if (!invalidTypes.isEmpty()) {
                throw new SpinRuntimeException("The following classes are not whitelisted for deserialization: " + invalidTypes);
            }
        }
    }

    protected void validateType(JavaType type, DeserializationTypeValidator validator, List<String> invalidTypes) {
        if (!type.isPrimitive()) {
            if (!type.isArrayType()) {
                this.validateTypeInternal(type, validator, invalidTypes);
            }
            if (type.isMapLikeType()) {
                this.validateType(type.getKeyType(), validator, invalidTypes);
            }
            if (type.isContainerType() || type.hasContentType()) {
                this.validateType(type.getContentType(), validator, invalidTypes);
            }
        }
    }

    protected void validateTypeInternal(JavaType type, DeserializationTypeValidator validator, List<String> invalidTypes) {
        String className = type.getRawClass().getName();
        if (!validator.validate(className) && !invalidTypes.contains(className)) {
            invalidTypes.add(className);
        }
    }
}

