/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom.util;

import org.cibseven.commons.utils.EnsureUtil;
import org.cibseven.spin.impl.xml.dom.DomXmlElement;
import org.cibseven.spin.impl.xml.dom.DomXmlLogger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomXmlEnsure
extends EnsureUtil {
    private static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    private static final String ROOT_EXPRESSION = "/";

    public static void ensureChildElement(DomXmlElement parentElement, DomXmlElement childElement) {
        Node parent = childElement.unwrap().getParentNode();
        if (parent == null || !parentElement.unwrap().isEqualNode(parent)) {
            throw LOG.elementIsNotChildOfThisElement(childElement, parentElement);
        }
    }

    public static void ensureNotDocumentRootExpression(String expression) {
        if (ROOT_EXPRESSION.equals(expression)) {
            throw LOG.notAllowedXPathExpression(expression);
        }
    }

    public static void ensureXPathNotNull(Node node, String expression) {
        if (node == null) {
            throw LOG.unableToFindXPathExpression(expression);
        }
    }

    public static void ensureXPathNotEmpty(NodeList nodeList, String expression) {
        if (nodeList == null || nodeList.getLength() == 0) {
            throw LOG.unableToFindXPathExpression(expression);
        }
    }
}

