/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.spin.impl.xml.dom.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.cibseven.spin.impl.xml.dom.DomXmlLogger;
import org.cibseven.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.cibseven.spin.spi.DataFormatWriter;
import org.w3c.dom.Node;

public class DomXmlDataFormatWriter
implements DataFormatWriter {
    protected static final DomXmlLogger LOG = DomXmlLogger.XML_DOM_LOGGER;
    protected static final String STRIP_SPACE_XSL = "org/cibseven/spin/impl/xml/dom/format/strip-space.xsl";
    protected DomXmlDataFormat domXmlDataFormat;
    protected Templates formattingTemplates;

    public DomXmlDataFormatWriter(DomXmlDataFormat domXmlDataFormat) {
        this.domXmlDataFormat = domXmlDataFormat;
        this.formattingTemplates = this.reloadFormattingTemplates();
    }

    @Override
    public void writeToWriter(Writer writer, Object input) {
        this.writeResult(new StreamResult(writer), input);
    }

    protected void writeResult(StreamResult streamResult, Object input) {
        Node node = (Node)input;
        DOMSource domSource = new DOMSource(node);
        try {
            if (this.domXmlDataFormat.isPrettyPrint()) {
                this.getFormattingTransformer().transform(domSource, streamResult);
            } else {
                this.getTransformer().transform(domSource, streamResult);
            }
        }
        catch (TransformerException e) {
            throw LOG.unableToTransformElement(node, e);
        }
    }

    protected Templates reloadFormattingTemplates() {
        Templates templates;
        block9: {
            TransformerFactory transformerFactory = this.domXmlDataFormat.getTransformerFactory();
            InputStream formattingConfiguration = this.getFormattingConfiguration();
            try {
                if (formattingConfiguration == null) {
                    throw LOG.unableToFindStripSpaceXsl(STRIP_SPACE_XSL);
                }
                templates = transformerFactory.newTemplates(new StreamSource(formattingConfiguration));
                if (formattingConfiguration == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (formattingConfiguration != null) {
                        try {
                            formattingConfiguration.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | TransformerConfigurationException ex) {
                    throw LOG.unableToLoadFormattingTemplates(ex);
                }
            }
            formattingConfiguration.close();
        }
        return templates;
    }

    protected void setFormattingTemplates(Templates formattingTemplates) {
        this.formattingTemplates = formattingTemplates;
    }

    private InputStream getFormattingConfiguration() {
        InputStream importedConfiguration = this.domXmlDataFormat.getFormattingConfiguration();
        if (importedConfiguration != null) {
            return importedConfiguration;
        }
        return DomXmlDataFormatWriter.class.getClassLoader().getResourceAsStream(STRIP_SPACE_XSL);
    }

    protected Transformer getFormattingTransformer() {
        try {
            Transformer transformer = this.formattingTemplates.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw LOG.unableToCreateTransformer(e);
        }
    }

    protected Transformer getTransformer() {
        TransformerFactory transformerFactory = this.domXmlDataFormat.getTransformerFactory();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw LOG.unableToCreateTransformer(e);
        }
    }
}

