/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.connect.impl;

import java.util.HashMap;
import java.util.Map;
import org.cibseven.connect.spi.Connector;
import org.cibseven.connect.spi.ConnectorRequest;
import org.cibseven.connect.spi.ConnectorResponse;

public abstract class AbstractConnectorRequest<R extends ConnectorResponse>
implements ConnectorRequest<R> {
    protected Connector connector;
    protected Map<String, Object> requestParameters = new HashMap<String, Object>();

    public AbstractConnectorRequest(Connector connector) {
        this.connector = connector;
    }

    @Override
    public R execute() {
        if (!this.isRequestValid()) {
            throw new RuntimeException("The request is invalid");
        }
        return (R)this.connector.execute(this);
    }

    protected boolean isRequestValid() {
        return true;
    }

    @Override
    public void setRequestParameters(Map<String, Object> params) {
        for (Map.Entry<String, Object> param : params.entrySet()) {
            this.setRequestParameter(param.getKey(), param.getValue());
        }
    }

    @Override
    public void setRequestParameter(String name, Object value) {
        this.requestParameters.put(name, value);
    }

    @Override
    public Map<String, Object> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public <V> V getRequestParameter(String name) {
        return (V)this.requestParameters.get(name);
    }
}

