/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.connect.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.cibseven.connect.spi.Connector;
import org.cibseven.connect.spi.ConnectorRequest;
import org.cibseven.connect.spi.ConnectorRequestInterceptor;
import org.cibseven.connect.spi.ConnectorResponse;

public abstract class AbstractConnector<Q extends ConnectorRequest<R>, R extends ConnectorResponse>
implements Connector<Q> {
    protected String connectorId;
    protected List<ConnectorRequestInterceptor> requestInterceptors = new LinkedList<ConnectorRequestInterceptor>();

    public AbstractConnector(String connectorId) {
        this.connectorId = connectorId;
    }

    @Override
    public String getId() {
        return this.connectorId;
    }

    @Override
    public List<ConnectorRequestInterceptor> getRequestInterceptors() {
        return this.requestInterceptors;
    }

    @Override
    public void setRequestInterceptors(List<ConnectorRequestInterceptor> requestInterceptors) {
        this.requestInterceptors = requestInterceptors;
    }

    @Override
    public Connector<Q> addRequestInterceptor(ConnectorRequestInterceptor interceptor) {
        this.requestInterceptors.add(interceptor);
        return this;
    }

    @Override
    public Connector<Q> addRequestInterceptors(Collection<ConnectorRequestInterceptor> interceptors) {
        this.requestInterceptors.addAll(interceptors);
        return this;
    }
}

