/*
 * Decompiled with CFR 0.152.
 */
package connectjar.org.apache.http.impl.execchain;

import connectjar.org.apache.commons.logging.Log;
import connectjar.org.apache.commons.logging.LogFactory;
import connectjar.org.apache.http.Header;
import connectjar.org.apache.http.HttpException;
import connectjar.org.apache.http.annotation.Contract;
import connectjar.org.apache.http.annotation.ThreadingBehavior;
import connectjar.org.apache.http.client.ServiceUnavailableRetryStrategy;
import connectjar.org.apache.http.client.methods.CloseableHttpResponse;
import connectjar.org.apache.http.client.methods.HttpExecutionAware;
import connectjar.org.apache.http.client.methods.HttpRequestWrapper;
import connectjar.org.apache.http.client.protocol.HttpClientContext;
import connectjar.org.apache.http.conn.routing.HttpRoute;
import connectjar.org.apache.http.impl.execchain.ClientExecChain;
import connectjar.org.apache.http.impl.execchain.RequestEntityProxy;
import connectjar.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

