/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.webapp.impl.util;

import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.cibseven.bpm.engine.ProcessEngine;
import org.cibseven.bpm.engine.rest.exception.RestException;
import org.cibseven.bpm.engine.rest.spi.ProcessEngineProvider;

public class ProcessEngineUtil {
    public static ProcessEngine lookupProcessEngine(String engineName) {
        ServiceLoader<ProcessEngineProvider> serviceLoader = ServiceLoader.load(ProcessEngineProvider.class);
        Iterator<ProcessEngineProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            ProcessEngineProvider provider = iterator.next();
            return provider.getProcessEngine(engineName);
        }
        throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Could not find an implementation of the " + ProcessEngineProvider.class + "- SPI");
    }
}

