/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.xml.test.assertions;

import org.assertj.core.api.AbstractAssert;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;
import org.cibseven.bpm.model.xml.type.attribute.Attribute;
import org.cibseven.bpm.model.xml.type.reference.Reference;

public abstract class AbstractReferenceAssert<S extends AbstractReferenceAssert<S, T>, T extends Reference<?>>
extends AbstractAssert<S, T> {
    protected AbstractReferenceAssert(T actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S hasIdentifier(ModelElementInstance instance, String identifier) {
        this.isNotNull();
        String actualIdentifier = ((Reference)this.actual).getReferenceIdentifier(instance);
        if (!identifier.equals(actualIdentifier)) {
            this.failWithMessage("Expected reference <%s> to have identifier <%s> but was <%s>", new Object[]{this.actual, identifier, actualIdentifier});
        }
        return (S)((Object)((AbstractReferenceAssert)this.myself));
    }

    public S hasTargetElement(ModelElementInstance instance, ModelElementInstance targetElement) {
        this.isNotNull();
        Object actualTargetElement = ((Reference)this.actual).getReferenceTargetElement(instance);
        if (!targetElement.equals(actualTargetElement)) {
            this.failWithMessage("Expected reference <%s> to have target element <%s> but was <%s>", new Object[]{this.actual, targetElement, actualTargetElement});
        }
        return (S)((Object)((AbstractReferenceAssert)this.myself));
    }

    public S hasNoTargetElement(ModelElementInstance instance) {
        this.isNotNull();
        Object actualTargetElement = ((Reference)this.actual).getReferenceTargetElement(instance);
        if (actualTargetElement != null) {
            this.failWithMessage("Expected reference <%s> to have no target element but has <%s>", new Object[]{actualTargetElement, actualTargetElement});
        }
        return (S)((Object)((AbstractReferenceAssert)this.myself));
    }

    public S hasTargetAttribute(Attribute<?> targetAttribute) {
        this.isNotNull();
        Attribute<String> actualTargetAttribute = ((Reference)this.actual).getReferenceTargetAttribute();
        if (!targetAttribute.equals(actualTargetAttribute)) {
            this.failWithMessage("Expected reference <%s> to have target attribute <%s> but was <%s>", new Object[]{this.actual, targetAttribute, actualTargetAttribute});
        }
        return (S)((Object)((AbstractReferenceAssert)this.myself));
    }
}

