/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.xml.impl.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.model.xml.impl.validation.ModelValidationResultImpl;
import org.cibseven.bpm.model.xml.impl.validation.ModelValidationResultsImpl;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;
import org.cibseven.bpm.model.xml.validation.ValidationResult;
import org.cibseven.bpm.model.xml.validation.ValidationResultCollector;
import org.cibseven.bpm.model.xml.validation.ValidationResultType;
import org.cibseven.bpm.model.xml.validation.ValidationResults;

public class ValidationResultsCollectorImpl
implements ValidationResultCollector {
    protected ModelElementInstance currentElement;
    protected Map<ModelElementInstance, List<ValidationResult>> collectedResults = new HashMap<ModelElementInstance, List<ValidationResult>>();
    protected int errorCount = 0;
    protected int warningCount = 0;

    @Override
    public void addError(int code, String message) {
        this.resultsForCurrentElement().add(new ModelValidationResultImpl(this.currentElement, ValidationResultType.ERROR, code, message));
        ++this.errorCount;
    }

    @Override
    public void addWarning(int code, String message) {
        this.resultsForCurrentElement().add(new ModelValidationResultImpl(this.currentElement, ValidationResultType.WARNING, code, message));
        ++this.warningCount;
    }

    public void setCurrentElement(ModelElementInstance currentElement) {
        this.currentElement = currentElement;
    }

    public ValidationResults getResults() {
        return new ModelValidationResultsImpl(this.collectedResults, this.errorCount, this.warningCount);
    }

    protected List<ValidationResult> resultsForCurrentElement() {
        List<ValidationResult> resultsByElement = this.collectedResults.get(this.currentElement);
        if (resultsByElement == null) {
            resultsByElement = new ArrayList<ValidationResult>();
            this.collectedResults.put(this.currentElement, resultsByElement);
        }
        return resultsByElement;
    }
}

