/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.model.bpmn.builder;

import org.cibseven.bpm.model.bpmn.BpmnModelException;
import org.cibseven.bpm.model.bpmn.BpmnModelInstance;
import org.cibseven.bpm.model.bpmn.builder.AbstractThrowEventBuilder;
import org.cibseven.bpm.model.bpmn.builder.EndEventBuilder;
import org.cibseven.bpm.model.bpmn.builder.IntermediateThrowEventBuilder;
import org.cibseven.bpm.model.bpmn.builder.SubProcessBuilder;
import org.cibseven.bpm.model.bpmn.builder.TransactionBuilder;
import org.cibseven.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.cibseven.bpm.model.bpmn.instance.EndEvent;
import org.cibseven.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.cibseven.bpm.model.bpmn.instance.SubProcess;
import org.cibseven.bpm.model.bpmn.instance.Transaction;
import org.cibseven.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractBpmnModelElementBuilder<B extends AbstractBpmnModelElementBuilder<B, E>, E extends BpmnModelElementInstance> {
    protected final BpmnModelInstance modelInstance;
    protected final E element;
    protected final B myself;

    protected AbstractBpmnModelElementBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        this.modelInstance = modelInstance;
        this.myself = (AbstractBpmnModelElementBuilder)selfType.cast(this);
        this.element = element;
    }

    public BpmnModelInstance done() {
        return this.modelInstance;
    }

    public SubProcessBuilder subProcessDone() {
        BpmnModelElementInstance lastSubProcess = this.element.getScope();
        if (lastSubProcess != null && lastSubProcess instanceof SubProcess) {
            return ((SubProcess)lastSubProcess).builder();
        }
        throw new BpmnModelException("Unable to find a parent subProcess.");
    }

    public TransactionBuilder transactionDone() {
        BpmnModelElementInstance lastTransaction = this.element.getScope();
        if (lastTransaction != null && lastTransaction instanceof Transaction) {
            return new TransactionBuilder(this.modelInstance, (Transaction)lastTransaction);
        }
        throw new BpmnModelException("Unable to find a parent transaction.");
    }

    public AbstractThrowEventBuilder throwEventDefinitionDone() {
        ModelElementInstance lastEvent = this.element.getDomElement().getParentElement().getModelElementInstance();
        if (lastEvent != null && lastEvent instanceof IntermediateThrowEvent) {
            return new IntermediateThrowEventBuilder(this.modelInstance, (IntermediateThrowEvent)lastEvent);
        }
        if (lastEvent != null && lastEvent instanceof EndEvent) {
            return new EndEventBuilder(this.modelInstance, (EndEvent)lastEvent);
        }
        throw new BpmnModelException("Unable to find a parent event.");
    }

    public E getElement() {
        return this.element;
    }
}

