/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.task;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.cibseven.bpm.client.impl.ExternalTaskClientLogger;
import org.cibseven.bpm.client.task.SortingDto;

public class OrderingConfig {
    protected static final ExternalTaskClientLogger LOG = ExternalTaskClientLogger.CLIENT_LOGGER;
    protected final List<OrderingProperty> orderingProperties;

    protected OrderingConfig(List<OrderingProperty> orderingProperties) {
        this.orderingProperties = orderingProperties;
    }

    public static OrderingConfig empty() {
        return new OrderingConfig(new ArrayList<OrderingProperty>());
    }

    public void configureField(SortingField field) {
        this.orderingProperties.add(OrderingProperty.of(field, null));
    }

    public void configureDirectionOnLastField(Direction direction) {
        OrderingProperty lastConfiguredProperty = this.validateAndGetLastConfiguredProperty();
        if (lastConfiguredProperty.getDirection() != null) {
            throw LOG.doubleDirectionConfigException();
        }
        lastConfiguredProperty.setDirection(direction);
        this.orderingProperties.add(lastConfiguredProperty);
    }

    protected OrderingProperty validateAndGetLastConfiguredProperty() {
        OrderingProperty lastConfiguredProperty = this.getLastConfiguredProperty();
        if (lastConfiguredProperty == null) {
            throw LOG.unspecifiedOrderByMethodException();
        }
        return lastConfiguredProperty;
    }

    public void validateOrderingProperties() {
        boolean hasMissingDirection = this.orderingProperties.stream().anyMatch(p -> p.getDirection() == null);
        if (hasMissingDirection) {
            throw LOG.missingDirectionException();
        }
    }

    public List<SortingDto> toSortingDtos() {
        return this.orderingProperties.stream().map(SortingDto::fromOrderingProperty).collect(Collectors.toList());
    }

    protected OrderingProperty getLastConfiguredProperty() {
        return !this.orderingProperties.isEmpty() ? this.orderingProperties.get(this.orderingProperties.size() - 1) : null;
    }

    public static class OrderingProperty {
        protected SortingField field;
        protected Direction direction;

        public static OrderingProperty of(SortingField field, Direction direction) {
            OrderingProperty result = new OrderingProperty();
            result.setField(field);
            result.setDirection(direction);
            return result;
        }

        public void setField(SortingField field) {
            this.field = field;
        }

        public SortingField getField() {
            return this.field;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Direction getDirection() {
            return this.direction;
        }
    }

    public static enum SortingField {
        CREATE_TIME("createTime");

        private final String name;

        private SortingField(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Direction {
        ASC,
        DESC;


        public String asString() {
            return super.name().toLowerCase();
        }
    }
}

