/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cibseven.bpm.client.impl.RequestExecutor;
import org.cibseven.bpm.client.task.ExternalTask;
import org.cibseven.bpm.client.task.OrderingConfig;
import org.cibseven.bpm.client.task.impl.ExternalTaskImpl;
import org.cibseven.bpm.client.task.impl.dto.BpmnErrorRequestDto;
import org.cibseven.bpm.client.task.impl.dto.CompleteRequestDto;
import org.cibseven.bpm.client.task.impl.dto.ExtendLockRequestDto;
import org.cibseven.bpm.client.task.impl.dto.FailureRequestDto;
import org.cibseven.bpm.client.task.impl.dto.LockRequestDto;
import org.cibseven.bpm.client.task.impl.dto.SetVariablesRequestDto;
import org.cibseven.bpm.client.topic.impl.dto.FetchAndLockRequestDto;
import org.cibseven.bpm.client.topic.impl.dto.TopicRequestDto;
import org.cibseven.bpm.client.variable.impl.TypedValueField;
import org.cibseven.bpm.client.variable.impl.TypedValues;

public class EngineClient {
    protected static final String EXTERNAL_TASK_RESOURCE_PATH = "/external-task";
    protected static final String EXTERNAL_TASK__PROCESS_RESOURCE_PATH = "/process-instance";
    protected static final String FETCH_AND_LOCK_RESOURCE_PATH = "/external-task/fetchAndLock";
    public static final String ID_PATH_PARAM = "{id}";
    protected static final String ID_RESOURCE_PATH = "/external-task/{id}";
    public static final String LOCK_RESOURCE_PATH = "/external-task/{id}/lock";
    public static final String EXTEND_LOCK_RESOURCE_PATH = "/external-task/{id}/extendLock";
    public static final String SET_VARIABLES_RESOURCE_PATH = "/process-instance/{id}/variables";
    public static final String UNLOCK_RESOURCE_PATH = "/external-task/{id}/unlock";
    public static final String COMPLETE_RESOURCE_PATH = "/external-task/{id}/complete";
    public static final String FAILURE_RESOURCE_PATH = "/external-task/{id}/failure";
    public static final String BPMN_ERROR_RESOURCE_PATH = "/external-task/{id}/bpmnError";
    public static final String NAME_PATH_PARAM = "{name}";
    public static final String PROCESS_INSTANCE_RESOURCE_PATH = "/process-instance";
    public static final String PROCESS_INSTANCE_ID_RESOURCE_PATH = "/process-instance/{id}";
    public static final String GET_BINARY_VARIABLE = "/process-instance/{id}/variables/{name}/data";
    protected String baseUrl;
    protected String workerId;
    protected int maxTasks;
    protected boolean usePriority;
    protected OrderingConfig orderingConfig;
    protected Long asyncResponseTimeout;
    protected RequestExecutor engineInteraction;
    protected TypedValues typedValues;

    public EngineClient(String workerId, int maxTasks, Long asyncResponseTimeout, String baseUrl, RequestExecutor engineInteraction) {
        this(workerId, maxTasks, asyncResponseTimeout, baseUrl, engineInteraction, true, OrderingConfig.empty());
    }

    public EngineClient(String workerId, int maxTasks, Long asyncResponseTimeout, String baseUrl, RequestExecutor engineInteraction, boolean usePriority, OrderingConfig orderingConfig) {
        this.workerId = workerId;
        this.asyncResponseTimeout = asyncResponseTimeout;
        this.maxTasks = maxTasks;
        this.usePriority = usePriority;
        this.engineInteraction = engineInteraction;
        this.baseUrl = baseUrl;
        this.orderingConfig = orderingConfig;
    }

    public List<ExternalTask> fetchAndLock(List<TopicRequestDto> topics) {
        FetchAndLockRequestDto payload = new FetchAndLockRequestDto(this.workerId, this.maxTasks, this.asyncResponseTimeout, topics, this.usePriority, this.orderingConfig);
        String resourceUrl = this.baseUrl + FETCH_AND_LOCK_RESOURCE_PATH;
        ExternalTask[] externalTasks = this.engineInteraction.postRequest(resourceUrl, payload, ExternalTaskImpl[].class);
        return Arrays.asList(externalTasks);
    }

    public void lock(String taskId, long lockDuration) {
        LockRequestDto payload = new LockRequestDto(this.workerId, lockDuration);
        String resourcePath = LOCK_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void unlock(String taskId) {
        String resourcePath = UNLOCK_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, null, Void.class);
    }

    public void complete(String taskId, Map<String, Object> variables, Map<String, Object> localVariables) {
        Map<String, TypedValueField> typedValueDtoMap = this.typedValues.serializeVariables(variables);
        Map<String, TypedValueField> localTypedValueDtoMap = this.typedValues.serializeVariables(localVariables);
        CompleteRequestDto payload = new CompleteRequestDto(this.workerId, typedValueDtoMap, localTypedValueDtoMap);
        String resourcePath = COMPLETE_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void setVariables(String processId, Map<String, Object> variables) {
        Map<String, TypedValueField> typedValueDtoMap = this.typedValues.serializeVariables(variables);
        SetVariablesRequestDto payload = new SetVariablesRequestDto(this.workerId, typedValueDtoMap);
        String resourcePath = SET_VARIABLES_RESOURCE_PATH.replace(ID_PATH_PARAM, processId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void failure(String taskId, String errorMessage, String errorDetails, int retries, long retryTimeout, Map<String, Object> variables, Map<String, Object> localVariables) {
        Map<String, TypedValueField> typedValueDtoMap = this.typedValues.serializeVariables(variables);
        Map<String, TypedValueField> localTypedValueDtoMap = this.typedValues.serializeVariables(localVariables);
        FailureRequestDto payload = new FailureRequestDto(this.workerId, errorMessage, errorDetails, retries, retryTimeout, typedValueDtoMap, localTypedValueDtoMap);
        String resourcePath = FAILURE_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void bpmnError(String taskId, String errorCode, String errorMessage, Map<String, Object> variables) {
        Map<String, TypedValueField> typeValueDtoMap = this.typedValues.serializeVariables(variables);
        BpmnErrorRequestDto payload = new BpmnErrorRequestDto(this.workerId, errorCode, errorMessage, typeValueDtoMap);
        String resourcePath = BPMN_ERROR_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public void extendLock(String taskId, long newDuration) {
        ExtendLockRequestDto payload = new ExtendLockRequestDto(this.workerId, newDuration);
        String resourcePath = EXTEND_LOCK_RESOURCE_PATH.replace(ID_PATH_PARAM, taskId);
        String resourceUrl = this.baseUrl + resourcePath;
        this.engineInteraction.postRequest(resourceUrl, payload, Void.class);
    }

    public byte[] getLocalBinaryVariable(String variableName, String executionId) {
        String resourcePath = this.baseUrl + GET_BINARY_VARIABLE.replace(ID_PATH_PARAM, executionId).replace(NAME_PATH_PARAM, variableName);
        return this.engineInteraction.getRequest(resourcePath);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getWorkerId() {
        return this.workerId;
    }

    public void setTypedValues(TypedValues typedValues) {
        this.typedValues = typedValues;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }
}

