/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH
 * under one or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information regarding copyright
 * ownership. Camunda licenses this file to you under the Apache License,
 * Version 2.0; you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cibseven.bpm.client.variable.impl.type;

import java.util.Map;

import org.cibseven.bpm.client.variable.ClientValues;
import org.cibseven.bpm.client.variable.value.JsonValue;
import org.cibseven.bpm.engine.variable.impl.type.PrimitiveValueTypeImpl;

public class JsonTypeImpl extends PrimitiveValueTypeImpl {

  private static final long serialVersionUID = 1L;

  public static final String JSON_TYPE_NAME = "json";

  public JsonTypeImpl() {
    super(JSON_TYPE_NAME, String.class);
  }

  public JsonValue createValue(Object value, Map<String, Object> valueInfo) {
    return ClientValues.jsonValue((String) value, isTransient(valueInfo));
  }

}
