/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.spring.impl.subscription.util;

import org.cibseven.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.cibseven.bpm.client.spring.exception.NotInitializedException;
import org.cibseven.bpm.client.spring.exception.NotOpenedException;
import org.cibseven.bpm.client.spring.impl.util.LoggerUtil;
import org.cibseven.bpm.client.task.ExternalTaskHandler;
import org.springframework.beans.factory.config.BeanDefinition;

public class SubscriptionLoggerUtil
extends LoggerUtil {
    public void handlerBeansFound(Class<ExternalTaskHandler> externalTaskHandlerClass, String[] beanNamesForType) {
        this.logDebug("001", "Handler beans found for {}: {}", new Object[]{externalTaskHandlerClass, beanNamesForType});
    }

    public void beanRegistered(String subscriptionBeanName, String handlerBeanName) {
        this.logDebug("002", "Subscription bean '{}' registered for handler bean '{}'", new Object[]{subscriptionBeanName, handlerBeanName});
    }

    public void notFound(BeanDefinition beanDefinition) {
        this.logInfo("003", "Subscription not found for handler bean {}", new Object[]{beanDefinition});
    }

    public void found(ExternalTaskSubscription annotation, BeanDefinition beanDefinition) {
        this.logDebug("004", "Subscription found {} for handler bean {}", new Object[]{annotation, beanDefinition});
    }

    public void initialized(String topicName) {
        this.logDebug("005", "Subscription for topic name {} initialized", new Object[]{topicName});
    }

    public void opened(String topicName) {
        this.logDebug("006", "Subscription for topic name {} opened", new Object[]{topicName});
    }

    public void closed(String topicName) {
        this.logDebug("007", "Subscription for topic name {} closed", new Object[]{topicName});
    }

    public NotInitializedException notInitializedException(String topicName) {
        return new NotInitializedException(this.exceptionMessage("008", "Subscription with topic name '{}' has yet not  been initialized", new Object[]{topicName}));
    }

    public NotOpenedException notOpenedException(String topicName) {
        return new NotOpenedException(this.exceptionMessage("009", "Subscription with topic name '{}' has yet not  been opened", new Object[]{topicName}));
    }
}

