/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.client.spring.impl.subscription;

import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.cibseven.bpm.client.ExternalTaskClient;
import org.cibseven.bpm.client.spring.SpringTopicSubscription;
import org.cibseven.bpm.client.spring.event.SubscriptionInitializedEvent;
import org.cibseven.bpm.client.spring.impl.client.util.ClientLoggerUtil;
import org.cibseven.bpm.client.spring.impl.subscription.SubscriptionConfiguration;
import org.cibseven.bpm.client.spring.impl.subscription.util.SubscriptionLoggerUtil;
import org.cibseven.bpm.client.task.ExternalTaskHandler;
import org.cibseven.bpm.client.topic.TopicSubscription;
import org.cibseven.bpm.client.topic.TopicSubscriptionBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;

public class SpringTopicSubscriptionImpl
implements SpringTopicSubscription,
InitializingBean {
    protected static final SubscriptionLoggerUtil LOG = ClientLoggerUtil.SUBSCRIPTION_LOGGER;
    protected SubscriptionConfiguration subscriptionConfiguration;
    protected ExternalTaskHandler externalTaskHandler;
    protected TopicSubscriptionBuilder topicSubscriptionBuilder;
    protected TopicSubscription topicSubscription;
    @Autowired
    protected ExternalTaskClient client;
    @Autowired
    protected ApplicationEventPublisher applicationEventPublisher;

    protected Predicate<ApplicationEvent> isEventThatCanStartSubscription() {
        return event -> event instanceof ContextRefreshedEvent;
    }

    @EventListener
    public void start(ApplicationEvent event) {
        if (this.isEventThatCanStartSubscription().test(event)) {
            this.initialize();
        }
    }

    public void initialize() {
        Boolean includeExtensionProperties;
        List<String> tenantIdIn;
        Boolean withoutTenantId;
        Map<String, Object> processVariablesEqualsIn;
        String processDefinitionVersionTag;
        List<String> processDefinitionKeyIn;
        String processDefinitionKey;
        List<String> processDefinitionIdIn;
        String processDefinitionId;
        String businessKey;
        Boolean localVariables;
        Long lockDuration;
        String topicName = this.subscriptionConfiguration.getTopicName();
        this.topicSubscriptionBuilder = this.client.subscribe(topicName).handler(this.externalTaskHandler);
        List<String> variableNames = this.subscriptionConfiguration.getVariableNames();
        if (variableNames != null) {
            this.topicSubscriptionBuilder.variables(this.toArray(variableNames));
        }
        if ((lockDuration = this.subscriptionConfiguration.getLockDuration()) != null) {
            this.topicSubscriptionBuilder.lockDuration(lockDuration.longValue());
        }
        if ((localVariables = this.subscriptionConfiguration.getLocalVariables()) != null && localVariables.booleanValue()) {
            this.topicSubscriptionBuilder.localVariables(true);
        }
        if ((businessKey = this.subscriptionConfiguration.getBusinessKey()) != null) {
            this.topicSubscriptionBuilder.businessKey(businessKey);
        }
        if ((processDefinitionId = this.subscriptionConfiguration.getProcessDefinitionId()) != null) {
            this.topicSubscriptionBuilder.processDefinitionId(processDefinitionId);
        }
        if ((processDefinitionIdIn = this.subscriptionConfiguration.getProcessDefinitionIdIn()) != null) {
            this.topicSubscriptionBuilder.processDefinitionIdIn(this.toArray(processDefinitionIdIn));
        }
        if ((processDefinitionKey = this.subscriptionConfiguration.getProcessDefinitionKey()) != null) {
            this.topicSubscriptionBuilder.processDefinitionKey(processDefinitionKey);
        }
        if ((processDefinitionKeyIn = this.subscriptionConfiguration.getProcessDefinitionKeyIn()) != null) {
            this.topicSubscriptionBuilder.processDefinitionKeyIn(this.toArray(processDefinitionKeyIn));
        }
        if ((processDefinitionVersionTag = this.subscriptionConfiguration.getProcessDefinitionVersionTag()) != null) {
            this.topicSubscriptionBuilder.processDefinitionVersionTag(processDefinitionVersionTag);
        }
        if ((processVariablesEqualsIn = this.subscriptionConfiguration.getProcessVariables()) != null) {
            this.topicSubscriptionBuilder.processVariablesEqualsIn(processVariablesEqualsIn);
        }
        if ((withoutTenantId = this.subscriptionConfiguration.getWithoutTenantId()) != null && withoutTenantId.booleanValue()) {
            this.topicSubscriptionBuilder.withoutTenantId();
        }
        if ((tenantIdIn = this.subscriptionConfiguration.getTenantIdIn()) != null) {
            this.topicSubscriptionBuilder.tenantIdIn(this.toArray(tenantIdIn));
        }
        if ((includeExtensionProperties = this.subscriptionConfiguration.getIncludeExtensionProperties()) != null && includeExtensionProperties.booleanValue()) {
            this.topicSubscriptionBuilder.includeExtensionProperties(true);
        }
        if (this.isAutoOpen()) {
            this.open();
        }
        this.publishInitializedEvent(topicName);
    }

    protected void publishInitializedEvent(String topicName) {
        SubscriptionInitializedEvent event = new SubscriptionInitializedEvent(this);
        this.applicationEventPublisher.publishEvent((ApplicationEvent)event);
        LOG.initialized(topicName);
    }

    @Override
    public void open() {
        String topicName = this.subscriptionConfiguration.getTopicName();
        if (this.topicSubscriptionBuilder == null) {
            throw LOG.notInitializedException(topicName);
        }
        this.topicSubscription = this.topicSubscriptionBuilder.open();
        LOG.opened(topicName);
    }

    @Override
    public boolean isOpen() {
        return this.topicSubscription != null;
    }

    public void closeInternally() {
        if (this.topicSubscription != null) {
            this.topicSubscription.close();
            this.topicSubscription = null;
            String topicName = this.subscriptionConfiguration.getTopicName();
            LOG.closed(topicName);
        }
    }

    @Override
    public void close() {
        String topicName = this.subscriptionConfiguration.getTopicName();
        if (this.topicSubscriptionBuilder == null) {
            throw LOG.notInitializedException(topicName);
        }
        if (this.topicSubscription == null) {
            throw LOG.notOpenedException(topicName);
        }
        this.closeInternally();
    }

    @Override
    public boolean isAutoOpen() {
        return this.subscriptionConfiguration.getAutoOpen();
    }

    public void setExternalTaskHandler(ExternalTaskHandler externalTaskHandler) {
        this.externalTaskHandler = externalTaskHandler;
    }

    public SubscriptionConfiguration getSubscriptionConfiguration() {
        return this.subscriptionConfiguration;
    }

    public void setSubscriptionConfiguration(SubscriptionConfiguration subscriptionConfiguration) {
        this.subscriptionConfiguration = subscriptionConfiguration;
    }

    public String getTopicName() {
        return this.subscriptionConfiguration.getTopicName();
    }

    public Long getLockDuration() {
        return this.subscriptionConfiguration.getLockDuration();
    }

    public ExternalTaskHandler getExternalTaskHandler() {
        return this.externalTaskHandler;
    }

    public List<String> getVariableNames() {
        return this.subscriptionConfiguration.getVariableNames();
    }

    public boolean isLocalVariables() {
        return this.subscriptionConfiguration.getLocalVariables();
    }

    public String getBusinessKey() {
        return this.subscriptionConfiguration.getBusinessKey();
    }

    public String getProcessDefinitionId() {
        return this.subscriptionConfiguration.getProcessDefinitionId();
    }

    public List<String> getProcessDefinitionIdIn() {
        return this.subscriptionConfiguration.getProcessDefinitionIdIn();
    }

    public String getProcessDefinitionKey() {
        return this.subscriptionConfiguration.getProcessDefinitionKey();
    }

    public List<String> getProcessDefinitionKeyIn() {
        return this.subscriptionConfiguration.getProcessDefinitionKeyIn();
    }

    public String getProcessDefinitionVersionTag() {
        return this.subscriptionConfiguration.getProcessDefinitionVersionTag();
    }

    public Map<String, Object> getProcessVariables() {
        return this.subscriptionConfiguration.getProcessVariables();
    }

    public boolean isWithoutTenantId() {
        return this.subscriptionConfiguration.getWithoutTenantId();
    }

    public List<String> getTenantIdIn() {
        return this.subscriptionConfiguration.getTenantIdIn();
    }

    public boolean isIncludeExtensionProperties() {
        return this.subscriptionConfiguration.getIncludeExtensionProperties();
    }

    protected String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public void afterPropertiesSet() throws Exception {
    }
}

