/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cibseven.bpm.engine.variable.type.ValueType;
import org.cibseven.bpm.engine.variable.type.ValueTypeResolver;

public class ValueTypeResolverImpl
implements ValueTypeResolver {
    protected Map<String, ValueType> knownTypes = new HashMap<String, ValueType>();

    public ValueTypeResolverImpl() {
        this.addType((ValueType)ValueType.BOOLEAN);
        this.addType((ValueType)ValueType.BYTES);
        this.addType((ValueType)ValueType.DATE);
        this.addType((ValueType)ValueType.DOUBLE);
        this.addType((ValueType)ValueType.INTEGER);
        this.addType((ValueType)ValueType.LONG);
        this.addType((ValueType)ValueType.NULL);
        this.addType((ValueType)ValueType.SHORT);
        this.addType((ValueType)ValueType.STRING);
        this.addType((ValueType)ValueType.OBJECT);
        this.addType((ValueType)ValueType.NUMBER);
        this.addType((ValueType)ValueType.FILE);
    }

    public void addType(ValueType type) {
        this.knownTypes.put(type.getName(), type);
    }

    public ValueType typeForName(String typeName) {
        return this.knownTypes.get(typeName);
    }

    public Collection<ValueType> getSubTypes(ValueType type) {
        ArrayList<ValueType> types = new ArrayList<ValueType>();
        HashSet<ValueType> validParents = new HashSet<ValueType>();
        validParents.add(type);
        for (ValueType knownType : this.knownTypes.values()) {
            if (!validParents.contains(knownType.getParent())) continue;
            validParents.add(knownType);
            if (knownType.isAbstract()) continue;
            types.add(knownType);
        }
        return types;
    }
}

