/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.cibseven.bpm.engine.runtime.WhitelistingDeserializationTypeValidator;

public class DefaultDeserializationTypeValidator
implements WhitelistingDeserializationTypeValidator {
    protected static final Collection<String> ALLOWED_PACKAGES = Arrays.asList("java.lang");
    protected static final Collection<String> ALLOWED_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.util.ArrayList", "java.util.Arrays$ArrayList", "java.util.HashMap", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.LinkedHashSet", "java.util.LinkedList", "java.util.Properties", "java.util.TreeMap", "java.util.TreeSet")));
    protected Set<String> allowedClasses = new HashSet<String>(ALLOWED_CLASSES);
    protected Set<String> allowedPackages = new HashSet<String>(ALLOWED_PACKAGES);

    @Override
    public void setAllowedClasses(String deserializationAllowedClasses) {
        this.extractElements(deserializationAllowedClasses, this.allowedClasses);
    }

    @Override
    public void setAllowedPackages(String deserializationAllowedPackages) {
        this.extractElements(deserializationAllowedPackages, this.allowedPackages);
    }

    @Override
    public boolean validate(String className) {
        if (className == null || className.trim().isEmpty()) {
            return true;
        }
        return this.isPackageAllowed(className) || this.isClassNameAllowed(className);
    }

    protected boolean isPackageAllowed(String className) {
        if (!this.isPackageAllowed(className, ALLOWED_PACKAGES)) {
            return this.isPackageAllowed(className, this.allowedPackages);
        }
        return true;
    }

    protected boolean isPackageAllowed(String className, Collection<String> allowedPackages) {
        for (String allowedPackage : allowedPackages) {
            if (allowedPackage.isEmpty() || !className.startsWith(allowedPackage)) continue;
            return true;
        }
        return false;
    }

    protected boolean isClassNameAllowed(String className) {
        if (!ALLOWED_CLASSES.contains(className)) {
            return this.allowedClasses.contains(className);
        }
        return true;
    }

    protected void extractElements(String allowedElements, Set<String> set) {
        String[] classes;
        if (!set.isEmpty()) {
            set.clear();
        }
        if (allowedElements == null) {
            return;
        }
        String allowedElementsSanitized = allowedElements.replaceAll("\\s", "");
        if (allowedElementsSanitized.isEmpty()) {
            return;
        }
        for (String className : classes = allowedElementsSanitized.split(",")) {
            set.add(className.trim());
        }
    }
}

