/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.pvm.runtime.operation;

import org.cibseven.bpm.engine.ProcessEngineException;
import org.cibseven.bpm.engine.impl.cmmn.behavior.TransferVariablesActivityBehavior;
import org.cibseven.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.cibseven.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.cibseven.bpm.engine.impl.core.model.CoreActivity;
import org.cibseven.bpm.engine.impl.pvm.PvmLogger;
import org.cibseven.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperationActivityInstanceEnd;

public class PvmAtomicOperationProcessEnd
extends PvmAtomicOperationActivityInstanceEnd {
    private static final PvmLogger LOG = PvmLogger.PVM_LOGGER;

    @Override
    protected ScopeImpl getScope(PvmExecutionImpl execution) {
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(PvmExecutionImpl execution) {
        CoreActivity activity;
        execution.leaveActivityInstance();
        PvmExecutionImpl superExecution = execution.getSuperExecution();
        CmmnExecution superCaseExecution = execution.getSuperCaseExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        TransferVariablesActivityBehavior transferVariablesBehavior = null;
        if (superExecution != null) {
            activity = superExecution.getActivity();
            subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            try {
                subProcessActivityBehavior.passOutputVariables(superExecution, execution);
            }
            catch (RuntimeException e) {
                LOG.exceptionWhileCompletingSupProcess(execution, e);
                throw e;
            }
            catch (Exception e) {
                LOG.exceptionWhileCompletingSupProcess(execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + String.valueOf(execution), e);
            }
        }
        if (superCaseExecution != null) {
            activity = superCaseExecution.getActivity();
            transferVariablesBehavior = (TransferVariablesActivityBehavior)((CmmnActivity)activity).getActivityBehavior();
            try {
                transferVariablesBehavior.transferVariables(execution, superCaseExecution);
            }
            catch (RuntimeException e) {
                LOG.exceptionWhileCompletingSupProcess(execution, e);
                throw e;
            }
            catch (Exception e) {
                LOG.exceptionWhileCompletingSupProcess(execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + String.valueOf(execution), e);
            }
        }
        execution.destroy();
        execution.remove();
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (RuntimeException e) {
                LOG.exceptionWhileCompletingSupProcess(execution, e);
                throw e;
            }
            catch (Exception e) {
                LOG.exceptionWhileCompletingSupProcess(execution, e);
                throw new ProcessEngineException("Error while completing sub process of execution " + String.valueOf(execution), e);
            }
        } else if (superCaseExecution != null) {
            superCaseExecution.complete();
        }
    }

    @Override
    public String getCanonicalName() {
        return "process-end";
    }
}

