/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.pvm.runtime;

import java.util.Map;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.pvm.process.ScopeImpl;
import org.cibseven.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;

public class CompensationBehavior {
    public static boolean executesNonScopeCompensationHandler(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        return execution.isScope() && activity != null && activity.isCompensationHandler() && !activity.isScope();
    }

    public static boolean isCompensationThrowing(PvmExecutionImpl execution) {
        Boolean isCompensationThrowing;
        ActivityImpl currentActivity = execution.getActivity();
        return currentActivity != null && (isCompensationThrowing = (Boolean)currentActivity.getProperty("throwsCompensation")) != null && isCompensationThrowing != false;
    }

    public static boolean executesDefaultCompensationHandler(PvmExecutionImpl scopeExecution) {
        ActivityImpl currentActivity = scopeExecution.getActivity();
        if (currentActivity != null) {
            return scopeExecution.isScope() && currentActivity.isScope() && !scopeExecution.getNonEventScopeExecutions().isEmpty() && !CompensationBehavior.isCompensationThrowing(scopeExecution);
        }
        return false;
    }

    public static String getParentActivityInstanceId(PvmExecutionImpl execution) {
        Map<ScopeImpl, PvmExecutionImpl> activityExecutionMapping = execution.createActivityExecutionMapping();
        PvmExecutionImpl parentScopeExecution = activityExecutionMapping.get(execution.getActivity().getFlowScope());
        return parentScopeExecution.getParentActivityInstanceId();
    }
}

