/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.cibseven.bpm.application.AbstractProcessApplication;
import org.cibseven.bpm.application.ProcessApplicationInterface;
import org.cibseven.bpm.application.ProcessApplicationReference;
import org.cibseven.bpm.application.ProcessApplicationUnavailableException;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.db.DbEntityLifecycleAware;
import org.cibseven.bpm.engine.impl.db.EnginePersistenceLogger;
import org.cibseven.bpm.engine.impl.interceptor.CommandContext;
import org.cibseven.bpm.engine.impl.interceptor.CommandContextListener;
import org.cibseven.bpm.engine.impl.persistence.entity.util.TypedValueUpdateListener;
import org.cibseven.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.cibseven.bpm.engine.impl.variable.serializer.ValueFields;
import org.cibseven.bpm.engine.impl.variable.serializer.ValueFieldsImpl;
import org.cibseven.bpm.engine.impl.variable.serializer.VariableSerializerFactory;
import org.cibseven.bpm.engine.impl.variable.serializer.VariableSerializers;
import org.cibseven.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.cibseven.bpm.engine.variable.type.ValueType;
import org.cibseven.bpm.engine.variable.value.SerializableValue;
import org.cibseven.bpm.engine.variable.value.TypedValue;

public class TypedValueField
implements DbEntityLifecycleAware,
CommandContextListener {
    protected static final EnginePersistenceLogger LOG = ProcessEngineLogger.PERSISTENCE_LOGGER;
    protected String serializerName;
    protected TypedValueSerializer<?> serializer;
    protected TypedValue cachedValue;
    protected String errorMessage;
    protected final ValueFields valueFields;
    protected boolean notifyOnImplicitUpdates = false;
    protected List<TypedValueUpdateListener> updateListeners;

    public TypedValueField(ValueFields valueFields, boolean notifyOnImplicitUpdates) {
        this.valueFields = valueFields;
        this.notifyOnImplicitUpdates = notifyOnImplicitUpdates;
        this.updateListeners = new ArrayList<TypedValueUpdateListener>();
    }

    public Object getValue() {
        TypedValue typedValue = this.getTypedValue(false);
        if (typedValue != null) {
            return typedValue.getValue();
        }
        return null;
    }

    public TypedValue getTypedValue(boolean asTransientValue) {
        return this.getTypedValue(true, asTransientValue);
    }

    public TypedValue getTypedValue(boolean deserializeValue, boolean asTransientValue) {
        if (Context.getCommandContext() != null) {
            if (this.cachedValue != null && this.cachedValue instanceof SerializableValue) {
                SerializableValue serializableValue = (SerializableValue)this.cachedValue;
                if (deserializeValue && !serializableValue.isDeserialized()) {
                    this.cachedValue = null;
                }
            }
            if (this.cachedValue != null && asTransientValue ^ this.cachedValue.isTransient()) {
                this.cachedValue = null;
            }
        }
        if (this.cachedValue == null && this.errorMessage == null) {
            try {
                this.cachedValue = this.getSerializer().readValue(this.valueFields, deserializeValue, asTransientValue);
                if (this.notifyOnImplicitUpdates && this.isMutableValue(this.cachedValue)) {
                    Context.getCommandContext().registerCommandContextListener(this);
                }
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    public TypedValue setValue(TypedValue value) {
        this.serializer = TypedValueField.getSerializers().findSerializerForValue((TypedValue)value, Context.getProcessEngineConfiguration().getFallbackSerializerFactory());
        this.serializerName = this.serializer.getName();
        if (value instanceof UntypedValueImpl) {
            value = this.serializer.convertToTypedValue((UntypedValueImpl)value);
        }
        this.writeValue((TypedValue)value, this.valueFields);
        this.cachedValue = value;
        if (this.notifyOnImplicitUpdates && this.isMutableValue(this.cachedValue)) {
            Context.getCommandContext().registerCommandContextListener(this);
        }
        return value;
    }

    public boolean isMutable() {
        return this.isMutableValue(this.cachedValue);
    }

    protected boolean isMutableValue(TypedValue value) {
        return this.getSerializer().isMutableValue(value);
    }

    protected boolean isValuedImplicitlyUpdated() {
        if (this.cachedValue != null && this.isMutableValue(this.cachedValue)) {
            byte[] byteArray = this.valueFields.getByteArrayValue();
            ValueFieldsImpl tempValueFields = new ValueFieldsImpl();
            this.writeValue(this.cachedValue, tempValueFields);
            byte[] byteArrayAfter = tempValueFields.getByteArrayValue();
            return !Arrays.equals(byteArray, byteArrayAfter);
        }
        return false;
    }

    protected void writeValue(TypedValue value, ValueFields valueFields) {
        this.getSerializer().writeValue(value, valueFields);
    }

    @Override
    public void onCommandContextClose(CommandContext commandContext) {
        this.notifyImplicitValueUpdateIfEnabled();
    }

    public void notifyImplicitValueUpdateIfEnabled() {
        if (TypedValueField.isImplicitVariableUpdateDetectionEnabled() && this.isValuedImplicitlyUpdated()) {
            for (TypedValueUpdateListener typedValueImplicitUpdateListener : this.updateListeners) {
                typedValueImplicitUpdateListener.onImplicitValueUpdate(this.cachedValue);
            }
        }
    }

    @Override
    public void onCommandFailed(CommandContext commandContext, Throwable t) {
    }

    public TypedValueSerializer<?> getSerializer() {
        this.ensureSerializerInitialized();
        return this.serializer;
    }

    private static boolean isImplicitVariableUpdateDetectionEnabled() {
        return Context.getProcessEngineConfiguration().isImplicitVariableUpdateDetectionEnabled();
    }

    protected void ensureSerializerInitialized() {
        if (this.serializerName != null && this.serializer == null) {
            this.serializer = TypedValueField.getSerializers().getSerializerByName(this.serializerName);
            if (this.serializer == null) {
                this.serializer = TypedValueField.getFallbackSerializer(this.serializerName);
            }
            if (this.serializer == null) {
                throw LOG.serializerNotDefinedException(this);
            }
        }
    }

    public static VariableSerializers getSerializers() {
        if (Context.getCommandContext() != null) {
            VariableSerializers variableSerializers = Context.getProcessEngineConfiguration().getVariableSerializers();
            VariableSerializers paSerializers = TypedValueField.getCurrentPaSerializers();
            if (paSerializers != null) {
                return variableSerializers.join(paSerializers);
            }
            return variableSerializers;
        }
        throw LOG.serializerOutOfContextException();
    }

    public static TypedValueSerializer<?> getFallbackSerializer(String serializerName) {
        if (Context.getProcessEngineConfiguration() != null) {
            VariableSerializerFactory fallbackSerializerFactory = Context.getProcessEngineConfiguration().getFallbackSerializerFactory();
            if (fallbackSerializerFactory != null) {
                return fallbackSerializerFactory.getSerializer(serializerName);
            }
            return null;
        }
        throw LOG.serializerOutOfContextException();
    }

    protected static VariableSerializers getCurrentPaSerializers() {
        if (Context.getCurrentProcessApplication() != null) {
            ProcessApplicationReference processApplicationReference = Context.getCurrentProcessApplication();
            try {
                ProcessApplicationInterface processApplicationInterface = processApplicationReference.getProcessApplication();
                ProcessApplicationInterface rawPa = processApplicationInterface.getRawObject();
                if (rawPa instanceof AbstractProcessApplication) {
                    return ((AbstractProcessApplication)rawPa).getVariableSerializers();
                }
                return null;
            }
            catch (ProcessApplicationUnavailableException e) {
                throw LOG.cannotDeterminePaDataformats(e);
            }
        }
        return null;
    }

    public String getSerializerName() {
        return this.serializerName;
    }

    public void setSerializerName(String serializerName) {
        this.serializerName = serializerName;
    }

    public void addImplicitUpdateListener(TypedValueUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public String getTypeName() {
        if (this.serializerName == null) {
            return ValueType.NULL.getName();
        }
        return this.getSerializer().getType().getName();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void postLoad() {
    }

    public void clear() {
        this.cachedValue = null;
    }
}

