/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cibseven.bpm.engine.impl.db.DbEntity;
import org.cibseven.bpm.engine.impl.db.HasDbReferences;
import org.cibseven.bpm.engine.impl.db.HasDbRevision;
import org.cibseven.bpm.engine.impl.jobexecutor.JobDeclaration;
import org.cibseven.bpm.engine.impl.persistence.entity.SuspensionState;
import org.cibseven.bpm.engine.management.JobDefinition;

public class JobDefinitionEntity
implements JobDefinition,
HasDbRevision,
HasDbReferences,
DbEntity,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String activityId;
    protected String jobType;
    protected String jobConfiguration;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected Long jobPriority;
    protected String tenantId;
    protected String deploymentId;

    public JobDefinitionEntity() {
    }

    public JobDefinitionEntity(JobDeclaration<?, ?> jobDeclaration) {
        this.activityId = jobDeclaration.getActivityId();
        this.jobConfiguration = jobDeclaration.getJobConfiguration();
        this.jobType = jobDeclaration.getJobHandlerType();
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("processDefinitionId", this.processDefinitionId);
        state.put("processDefinitionKey", this.processDefinitionKey);
        state.put("activityId", this.activityId);
        state.put("jobType", this.jobType);
        state.put("jobConfiguration", this.jobConfiguration);
        state.put("suspensionState", this.suspensionState);
        state.put("jobPriority", this.jobPriority);
        state.put("tenantId", this.tenantId);
        state.put("deploymentId", this.deploymentId);
        return state;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    @Override
    public boolean isSuspended() {
        return SuspensionState.SUSPENDED.getStateCode() == this.suspensionState;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @Override
    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    @Override
    public String getJobConfiguration() {
        return this.jobConfiguration;
    }

    public void setJobConfiguration(String jobConfiguration) {
        this.jobConfiguration = jobConfiguration;
    }

    @Override
    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int state) {
        this.suspensionState = state;
    }

    @Override
    public Long getOverridingJobPriority() {
        return this.jobPriority;
    }

    public void setJobPriority(Long jobPriority) {
        this.jobPriority = jobPriority;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public Set<String> getReferencedEntityIds() {
        HashSet<String> referencedEntityIds = new HashSet<String>();
        return referencedEntityIds;
    }

    @Override
    public Map<String, Class> getReferencedEntitiesIdAndClass() {
        HashMap<String, Class> referenceIdAndClass = new HashMap<String, Class>();
        return referenceIdAndClass;
    }
}

