/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration.validation.instruction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cibseven.bpm.engine.impl.bpmn.behavior.CallActivityBehavior;
import org.cibseven.bpm.engine.impl.bpmn.behavior.CaseCallActivityBehavior;
import org.cibseven.bpm.engine.impl.bpmn.behavior.EventSubProcessActivityBehavior;
import org.cibseven.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidationReportImpl;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.MigrationInstructionValidator;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstruction;
import org.cibseven.bpm.engine.impl.migration.validation.instruction.ValidatingMigrationInstructions;
import org.cibseven.bpm.engine.impl.pvm.process.ActivityImpl;
import org.cibseven.bpm.engine.impl.util.CollectionUtil;

public class SameBehaviorInstructionValidator
implements MigrationInstructionValidator {
    public static final List<Set<Class<?>>> EQUIVALENT_BEHAVIORS = new ArrayList();
    protected Map<Class<?>, Set<Class<?>>> equivalentBehaviors = new HashMap();

    public SameBehaviorInstructionValidator() {
        this(EQUIVALENT_BEHAVIORS);
    }

    public SameBehaviorInstructionValidator(List<Set<Class<?>>> equivalentBehaviors) {
        for (Set<Class<?>> equivalenceClass : equivalentBehaviors) {
            for (Class<?> clazz : equivalenceClass) {
                this.equivalentBehaviors.put(clazz, equivalenceClass);
            }
        }
    }

    @Override
    public void validate(ValidatingMigrationInstruction instruction, ValidatingMigrationInstructions instructions, MigrationInstructionValidationReportImpl report) {
        Class<?> targetBehaviorClass;
        ActivityImpl sourceActivity = instruction.getSourceActivity();
        ActivityImpl targetActivity = instruction.getTargetActivity();
        Class<?> sourceBehaviorClass = sourceActivity.getActivityBehavior().getClass();
        if (!this.sameBehavior(sourceBehaviorClass, targetBehaviorClass = targetActivity.getActivityBehavior().getClass())) {
            report.addFailure("Activities have incompatible types (" + sourceBehaviorClass.getSimpleName() + " is not compatible with " + targetBehaviorClass.getSimpleName() + ")");
        }
    }

    protected boolean sameBehavior(Class<?> sourceBehavior, Class<?> targetBehavior) {
        if (sourceBehavior == targetBehavior) {
            return true;
        }
        Set<Class<?>> equivalentBehaviors = this.equivalentBehaviors.get(sourceBehavior);
        if (equivalentBehaviors != null) {
            return equivalentBehaviors.contains(targetBehavior);
        }
        return false;
    }

    static {
        EQUIVALENT_BEHAVIORS.add(CollectionUtil.asHashSet(CallActivityBehavior.class, CaseCallActivityBehavior.class));
        EQUIVALENT_BEHAVIORS.add(CollectionUtil.asHashSet(SubProcessActivityBehavior.class, EventSubProcessActivityBehavior.class));
    }
}

