/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.migration.instance;

import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.context.Context;
import org.cibseven.bpm.engine.impl.history.HistoryLevel;
import org.cibseven.bpm.engine.impl.history.event.HistoryEvent;
import org.cibseven.bpm.engine.impl.history.event.HistoryEventProcessor;
import org.cibseven.bpm.engine.impl.history.event.HistoryEventTypes;
import org.cibseven.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.cibseven.bpm.engine.impl.migration.MigrationLogger;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingActivityInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingScopeInstance;
import org.cibseven.bpm.engine.impl.migration.instance.MigratingTransitionInstance;
import org.cibseven.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.TaskEntity;
import org.cibseven.bpm.engine.impl.persistence.entity.VariableInstanceEntity;

public class MigratingUserTaskInstance
implements MigratingInstance {
    public static final MigrationLogger MIGRATION_LOGGER = ProcessEngineLogger.MIGRATION_LOGGER;
    protected TaskEntity userTask;
    protected MigratingActivityInstance migratingActivityInstance;

    public MigratingUserTaskInstance(TaskEntity userTask, MigratingActivityInstance migratingActivityInstance) {
        this.userTask = userTask;
        this.migratingActivityInstance = migratingActivityInstance;
    }

    @Override
    public void migrateDependentEntities() {
    }

    @Override
    public boolean isDetached() {
        return this.userTask.getExecutionId() == null;
    }

    @Override
    public void detachState() {
        this.userTask.getExecution().removeTask(this.userTask);
        this.userTask.setExecution(null);
    }

    @Override
    public void attachState(MigratingScopeInstance owningInstance) {
        ExecutionEntity representativeExecution = owningInstance.resolveRepresentativeExecution();
        representativeExecution.addTask(this.userTask);
        for (VariableInstanceEntity variable : this.userTask.getVariablesInternal()) {
            variable.setExecution(representativeExecution);
        }
        this.userTask.setExecution(representativeExecution);
    }

    @Override
    public void attachState(MigratingTransitionInstance targetTransitionInstance) {
        throw MIGRATION_LOGGER.cannotAttachToTransitionInstance(this);
    }

    @Override
    public void migrateState() {
        this.userTask.setProcessDefinitionId(this.migratingActivityInstance.getTargetScope().getProcessDefinition().getId());
        this.userTask.setTaskDefinitionKey(this.migratingActivityInstance.getTargetScope().getId());
        this.migrateHistory();
    }

    protected void migrateHistory() {
        HistoryLevel historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel.isHistoryEventProduced(HistoryEventTypes.TASK_INSTANCE_MIGRATE, this)) {
            HistoryEventProcessor.processHistoryEvents(new HistoryEventProcessor.HistoryEventCreator(){

                @Override
                public HistoryEvent createHistoryEvent(HistoryEventProducer producer) {
                    return producer.createTaskInstanceMigrateEvt(MigratingUserTaskInstance.this.userTask);
                }
            });
        }
    }
}

