/*
 * Decompiled with CFR 0.152.
 */
package org.cibseven.bpm.engine.impl.management;

import java.util.Date;
import org.cibseven.bpm.engine.impl.ProcessEngineLogger;
import org.cibseven.bpm.engine.impl.cmd.ActivateJobDefinitionCmd;
import org.cibseven.bpm.engine.impl.cmd.CommandLogger;
import org.cibseven.bpm.engine.impl.cmd.SuspendJobDefinitionCmd;
import org.cibseven.bpm.engine.impl.interceptor.CommandExecutor;
import org.cibseven.bpm.engine.impl.util.EnsureUtil;
import org.cibseven.bpm.engine.management.UpdateJobDefinitionSuspensionStateBuilder;
import org.cibseven.bpm.engine.management.UpdateJobDefinitionSuspensionStateSelectBuilder;
import org.cibseven.bpm.engine.management.UpdateJobDefinitionSuspensionStateTenantBuilder;

public class UpdateJobDefinitionSuspensionStateBuilderImpl
implements UpdateJobDefinitionSuspensionStateBuilder,
UpdateJobDefinitionSuspensionStateSelectBuilder,
UpdateJobDefinitionSuspensionStateTenantBuilder {
    private static final CommandLogger LOG = ProcessEngineLogger.CMD_LOGGER;
    protected final CommandExecutor commandExecutor;
    protected String jobDefinitionId;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processDefinitionTenantId;
    protected boolean isProcessDefinitionTenantIdSet = false;
    protected boolean includeJobs = false;
    protected Date executionDate;

    public UpdateJobDefinitionSuspensionStateBuilderImpl(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public UpdateJobDefinitionSuspensionStateBuilderImpl() {
        this(null);
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl byJobDefinitionId(String jobDefinitionId) {
        EnsureUtil.ensureNotNull("jobDefinitionId", (Object)jobDefinitionId);
        this.jobDefinitionId = jobDefinitionId;
        return this;
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl byProcessDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl byProcessDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl processDefinitionWithoutTenantId() {
        this.processDefinitionTenantId = null;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl processDefinitionTenantId(String tenantId) {
        EnsureUtil.ensureNotNull("tenantId", (Object)tenantId);
        this.processDefinitionTenantId = tenantId;
        this.isProcessDefinitionTenantIdSet = true;
        return this;
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl includeJobs(boolean includeJobs) {
        this.includeJobs = includeJobs;
        return this;
    }

    @Override
    public UpdateJobDefinitionSuspensionStateBuilderImpl executionDate(Date executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @Override
    public void activate() {
        this.validateParameters();
        ActivateJobDefinitionCmd command = new ActivateJobDefinitionCmd(this);
        this.commandExecutor.execute(command);
    }

    @Override
    public void suspend() {
        this.validateParameters();
        SuspendJobDefinitionCmd command = new SuspendJobDefinitionCmd(this);
        this.commandExecutor.execute(command);
    }

    protected void validateParameters() {
        EnsureUtil.ensureOnlyOneNotNull("Need to specify either a job definition id, a process definition id or a process definition key.", this.jobDefinitionId, this.processDefinitionId, this.processDefinitionKey);
        if (this.isProcessDefinitionTenantIdSet && (this.jobDefinitionId != null || this.processDefinitionId != null)) {
            throw LOG.exceptionUpdateSuspensionStateForTenantOnlyByProcessDefinitionKey();
        }
        EnsureUtil.ensureNotNull("commandExecutor", (Object)this.commandExecutor);
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionTenantId() {
        return this.processDefinitionTenantId;
    }

    public boolean isProcessDefinitionTenantIdSet() {
        return this.isProcessDefinitionTenantIdSet;
    }

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public boolean isIncludeJobs() {
        return this.includeJobs;
    }

    public Date getExecutionDate() {
        return this.executionDate;
    }
}

